<?php

namespace App\Http\Controllers\Dashboard\Configuraciones\Permisos;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\c_categorias_permiso;
use Stevebauman\Location\Facades\Location;

class CategoriasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function logRegistro($request, $status, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_categoria' => $request->all()
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Registro de categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Registro de categoria de permisos del sistema fallida");
        }
    }

    public function logActulizacion($request, $status, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_categoria' => $request->all()
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Actualizacion de categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Actualizacion de categoria de permisos del sistema fallida");
        }
    }

    public function logEliminacion($request, $status, $categoria, $mensaje)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje,
            'datos_categoria' => $categoria
        ];

        if ($status == 'ok') {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->info("Eliminacion de categoria de permisos del sistema exitosa");
        } else {
            //Guardamos los datos en un archivo de log
            Log::withContext($arrayDatos)->warning("Eliminacion de categoria de permisos del sistema fallida");
        }
    }

    public function show()
    {
        return view('dashboard.configuraciones.permisos.categorias');
    }

    public function categoriasData()
    {
        $data = c_categorias_permiso::all();

        return DataTables::of($data)
            ->addColumn('action', function ($categoria) {
                return view('layouts.dashboard.partials.permisos.categorias.botones', compact('categoria'));
            })->make(true);
    }

    public function categoriaData($id_categoria)
    {
        //Se obtiene los datos de la categoria
        $categoriaData = c_categorias_permiso::findOrFail($id_categoria);

        //Retorna los datos del rol y los permisos en formato json
        return Response()->json(["success" => true, 'data' => $categoriaData]);
    }

    public function registraCategoria(Request $request)
    {
        $validaNombreCategoria = c_categorias_permiso::where('categoria', $request->nombre_categoria_permiso)->count();

        if ($validaNombreCategoria >= 1) {
            $mensaje = 'El nombre de la categoria ya se encuentra registrada';
            $this->logRegistro($request, 'error', $mensaje);
            notify()->error($mensaje, 'Registro de categoria');
        } else {
            c_categorias_permiso::create([
                'categoria' => strtoupper($request->nombre_categoria_permiso),
                'activo' => $request->estado
            ]);

            $mensaje = 'Categoria registrada correctamente';
            $this->logRegistro($request, 'ok', $mensaje);
            notify()->success($mensaje, 'Registro de categoria');
        }

        return redirect()->route('configuraciones.permisos.categorias');
    }

    public function actulizaCategoria(Request $request)
    {
        //Recuperamos el id de la categoria
        $id_categoria = $request->id_categoria_edit;

        //Se obtiene el nombre de la categoria
        $nombreCategoria = $request->nombre_categoria_edit;

        //Verifica si el nombre de la ya se encuentra registrada
        $validaNombreCategoria = c_categorias_permiso::where('categoria', $nombreCategoria)->where('id', '!=', $id_categoria)->count();

        if ($validaNombreCategoria >= 1) {
            $mensaje = 'El nombre de la categoria ya se encuentra registrado';
            $this->logActulizacion($request, 'error', $mensaje);
            notify()->error($mensaje, 'Actualizacion de categoria');
        } else {
            //Recuperamos la categoria a actualizar
            $categoria = c_categorias_permiso::findOrFail($id_categoria);

            //Actualizamos los datos de la categoria
            $categoria->categoria = strtoupper($nombreCategoria);
            $categoria->activo = $request->estado_edit;
            $categoria->update();

            $mensaje = 'Categoria actualizada correctamente';
            $this->logActulizacion($request, 'ok', $mensaje);
            notify()->success($mensaje, 'Actualizacion de categoria');
        }

        return redirect()->route('configuraciones.permisos.categorias');
    }

    public function eliminaCategoria(Request $request)
    {
        $id =$request->id_categoria_destroy;

        //Recuperamos la categoria a eliminar
        $categoria = c_categorias_permiso::findOrFail($id);

        //Valida si la categoria tiene permisos asignados
        $validaCategoriaPermiso = DB::table('permissions')->where('id_category', '=', $id)->count();

        if($validaCategoriaPermiso >= 1){
            $mensaje = 'La categoria no puede ser eliminada ya que esta asignada a un permiso';
            $this->logEliminacion($request, 'error', $categoria, $mensaje);
            notify()->error($mensaje, 'Eliminación de categoria');
        }else{
            $categoria->delete();

            $mensaje = 'Categoria eliminada correctamente';
            $this->logEliminacion($request, 'ok', $categoria, $mensaje);
            notify()->success($mensaje, 'Eliminación de categoria');
        }

        return redirect()->route('configuraciones.permisos.categorias');
    }
}
