<?php

namespace App\Http\Controllers\Dashboard\Movimientos;

use App\Models\Producto;
use App\Models\Sucursale;
use Illuminate\Http\Request;
use App\Models\RegistroMovimientos;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Models\NumeroReceta;
use Stevebauman\Location\Facades\Location;

class RegistraMovimientosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function show()
    {
        $listaSucursales = "";

        if (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') {
            $listaSucursales = Sucursale::select('sucursal', 'nombre')->where('activa', 1)->get();
        }

        return view('dashboard.movimientos.registro', compact('listaSucursales'));
    }


    public function getDatosProducto(Request $request)
    {
        $validaExisteProducto = Producto::select('id_productos', 'producto', 'fabricante')->where('codigo_producto', $request->codigo_producto)->get();

        if (!empty($validaExisteProducto[0])) {
            $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $request->sucursal : session('sucursalSession');

            $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);
            $tableRegistros = new RegistroMovimientos();
            $tableRegistros->setTable($tablaSucursal);


            $validaRegistroProducto = $tableRegistros->select('id')->where('codigo_producto', $request->codigo_producto)->count();

            if ($validaRegistroProducto >= 1) {
                return $tableRegistros->select('id', 'producto', 'denominacion_dist', 'denominacion_gen', 'presentacion', 'laboratorio', 'saldo')
                    ->find($tableRegistros->where('codigo_producto', $request->codigo_producto)->max('id'));
            } else {
                return Response()->json([
                    "success" => true,
                    "id" => 0,
                    'producto' => $validaExisteProducto[0]->producto,
                    "laboratorio" => $validaExisteProducto[0]->fabricante,
                    "saldo" => 0
                ]);
            }
        } else {
            return response()->json(['error' => "El producto no se encuentra registrado"], 500);
        }
    }


    public function registraEntrada(Request $request)
    {
        $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $request->sucursal : session('sucursalSession');
        $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);

        $observaciones = $request->observaciones == null ? "" : $request->observaciones;

        $registraEntrada = new RegistroMovimientos();
        $registraEntrada->setTable($tablaSucursal);

        $registraEntrada->tipo_movimiento = 'ENTRADA';
        $registraEntrada->fecha = date('Y-m-d');
        $registraEntrada->hora = date('H:i:s');
        $registraEntrada->codigo_producto = $request->codigoProducto;
        $registraEntrada->producto = strtoupper($request->producto);
        $registraEntrada->denominacion_dist = strtoupper($request->denominacionDist);
        $registraEntrada->denominacion_gen = strtoupper($request->denominacionGen);
        $registraEntrada->presentacion = strtoupper($request->presentacion);
        $registraEntrada->laboratorio = strtoupper($request->laboratorio);
        $registraEntrada->procedencia = strtoupper($request->procedencia);
        $registraEntrada->nombre_pree = "N/A";
        $registraEntrada->domicilio = strtoupper($request->domicilio);
        $registraEntrada->cedula = "N/A";
        $registraEntrada->factura = strtoupper($request->numFactura);
        $registraEntrada->receta = "N/A";
        $registraEntrada->cantidad_adquirida = $request->cantidad;
        $registraEntrada->cantidad_vendida = 0;
        $registraEntrada->saldo = $request->saldo;
        $registraEntrada->observaciones = $observaciones;
        $registraEntrada->save();

        $mensaje = "Entrada al libro de antibiotico registrada correctamente.";
        RegistraMovimientosController::logRegistro($request, $mensaje, $sucursal, 'Entrada');

        return Response()->json(["success" => true,  "mensaje" => $mensaje]);
    }

    public function registraSalida(Request $request)
    {
        $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $request->sucursal : session('sucursalSession');
        $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);

        $numeroReceta = $request->surtido == "total" ? $this->getNumeroReceta($sucursal) : "P";

        $observaciones = $request->observaciones == null ? "" : $request->observaciones;

        $registraSalida = new RegistroMovimientos();
        $registraSalida->setTable($tablaSucursal);

        $registraSalida->tipo_movimiento = 'SALIDA';
        $registraSalida->fecha = date('Y-m-d');
        $registraSalida->hora = date('H:i:s');
        $registraSalida->codigo_producto = $request->codigoProducto;
        $registraSalida->producto = strtoupper($request->producto);
        $registraSalida->denominacion_dist = strtoupper($request->denominacionDist);
        $registraSalida->denominacion_gen = strtoupper($request->denominacionGen);
        $registraSalida->presentacion = strtoupper($request->presentacion);
        $registraSalida->laboratorio = strtoupper($request->laboratorio);
        $registraSalida->procedencia = "N/A";
        $registraSalida->nombre_pree = strtoupper($request->preescribe);
        $registraSalida->domicilio = strtoupper($request->domicilio);
        $registraSalida->cedula = strtoupper($request->cedulaSalida);
        $registraSalida->factura = "N/A";
        $registraSalida->receta = $numeroReceta;
        $registraSalida->cantidad_adquirida = 0;
        $registraSalida->cantidad_vendida = $request->cantidad;
        $registraSalida->saldo = $request->saldo;
        $registraSalida->observaciones = $observaciones;
        $registraSalida->save();

        $mensaje = "Salida del libro de antibiotico registrada correctamente. (Numero de receta: " . $numeroReceta . ")";
        RegistraMovimientosController::logRegistro($request, $mensaje, $sucursal, 'Salida');

        return Response()->json(["success" => true,  "mensaje" => $mensaje]);
    }

    //Función para obtener el número de receta
    private function getNumeroReceta($sucursal)
    {
        $tableNumReceta = new NumeroReceta();
        $consultaNumeroReceta = $tableNumReceta->select('id', 'numero_receta')->where('sucursal', $sucursal)->get();
        $numeroReceta = $consultaNumeroReceta[0]->numero_receta + 1;

        $actulizaNumero = $tableNumReceta->find($consultaNumeroReceta[0]->id);
        $actulizaNumero->numero_receta = $numeroReceta;
        $actulizaNumero->update();

        Log::info("Numero de receta obtenido [" . $sucursal . " - " . $numeroReceta . " ]");
        return $numeroReceta;
    }

    private static function logRegistro(Request $request, $mensaje, $sucursal, $tipoMovimiento)
    {
        $arrayDatos = [
            'fecha/hora' => date('Y-m-d H:i:s'),
            'username' => session('nombreUsuarioSession'),
            'user_agent' => $request->header('User-Agent'),
            'url' => $request->fullUrl() . ' [' . $request->method() . ']',
            'location' => Location::get($request->ip()),
            'menseje' => $mensaje
        ];

        Log::withContext($arrayDatos)->info($tipoMovimiento . " al libro de antibiotico registrada correctamente [" . $sucursal . "]");
    }
}
