<?php

namespace App\Http\Controllers\Dashboard\Reportes;

//use Barryvdh\DomPDF\PDF;



use App\Models\Sucursale;
use Yajra\DataTables\DataTables;
use App\Models\RegistroMovimientos;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

// Declaramos la librería Html2Pdf
require '../vendor/autoload.php';

use Spipu\Html2Pdf\Html2Pdf;

class ReporteMovimientosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function show()
    {
        if (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') {
            $listaSucursales = Sucursale::select('sucursal', 'nombre')->where('activa', 1)->get();
        } else {
            $listaSucursales = Sucursale::select('sucursal', 'nombre')->where('sucursal', session('sucursalSession'))->get();
        }

        return view('dashboard.reportes.movimientos', compact('listaSucursales'));
    }

    public function getdataMovimientos($filtroBusqueda, $sucursal, $fechaInicial, $fechaFinal, $tipoMovimiento)
    {
        $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $sucursal : session('sucursalSession');

        $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);
        $tableRegistros = new RegistroMovimientos();
        $tableRegistros->setTable($tablaSucursal);

        if ($filtroBusqueda != "TODOS") {
            $data = $tableRegistros
                ->where('tipo_movimiento', $tipoMovimiento)
                ->where(function ($query) use ($filtroBusqueda) {
                    $query->where('codigo_producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_dist', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_gen', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('cedula', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('factura', 'LIKE', '%' . $filtroBusqueda . '%');
                })
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        } else if ($filtroBusqueda == "TODOS") {
            $data = $tableRegistros
                ->where('tipo_movimiento', $tipoMovimiento)
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        }

        //Log::info("Reporte de la sucursal [" . $sucursal . "] generado exitosamente");
        return DataTables::of($data)->make(true);
    }

    private static function getTituloReporte($tipoSucursal, $nombreSucursal, $sucursal)
    {
        if ($sucursal == 'FCDIS' || $sucursal == 'SMCAS') {
            $titulo = "CONTROL DE ANTIBIÓTICOS " . $tipoSucursal . " MEDICA DEL CARMEN FARMACIA " . $nombreSucursal;
        } else if ($sucursal == 'FCMOT' || $sucursal == 'FCCHL') {
            $titulo = "CONTROL DE ANTIBIÓTICOS INSUMOS PARA LA SALUD HR SA DE CV SUCURSAL " . $nombreSucursal;
        } else if ($tipoSucursal == 'FARMACIA') {
            $titulo = "CONTROL DE ANTIBIÓTICOS " . $tipoSucursal . "S DEL CARMEN SUCURSAL " . $nombreSucursal;
        } else if ($tipoSucursal == 'SURTIDORA') {
            $titulo = "CONTROL DE ANTIBIÓTICOS " . $tipoSucursal . " MEDICA DEL CARMEN SUCURSAL " . $nombreSucursal;
        }

        return $titulo;
    }


    public function getReportePDF($filtroBusqueda, $sucursal, $fechaInicial, $fechaFinal)
    {
        $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $sucursal : session('sucursalSession');
        $datosSucursal = Sucursale::where('sucursal', $sucursal)->get();

        $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);
        $tableRegistros = new RegistroMovimientos();
        $tableRegistros->setTable($tablaSucursal);

        if ($filtroBusqueda != "TODOS") {
            $consultaRegistros = $tableRegistros
                ->where(function ($query) use ($filtroBusqueda) {
                    $query->where('codigo_producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_dist', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_gen', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('cedula', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('factura', 'LIKE', '%' . $filtroBusqueda . '%');
                })
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        } else if ($filtroBusqueda == "TODOS") {
            $consultaRegistros = $tableRegistros
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        }


        $jsonDatos = json_encode($consultaRegistros);
        $data = json_decode($jsonDatos, true);

        $titulo = ReporteMovimientosController::getTituloReporte($datosSucursal[0]->tipo, $datosSucursal[0]->nombre, $sucursal);

        //Genera la consulta de los datos y el nombre del archivo, dependiendo los datos del filtrado
        $fileName = "Reporte_libro_antibiotico_" . $sucursal . "_" . $fechaInicial . "_" . $fechaFinal . ".pdf";

        $HTML = view('dashboard.reportes.reportePDF', compact('titulo', 'fechaInicial', 'fechaFinal', 'data'));


        $html2pdf = new Html2Pdf('L', 'LETTER', 'es', 'true', 'UTF-8');
        $html2pdf->writeHTML($HTML);
        $PDFGenerado = $html2pdf->output($fileName, 'S');

        return Response()->json(["success" => true, 'nameFile' => $fileName, 'file' => "data:application/vnd.ms-Excel;base64," . base64_encode($PDFGenerado)]);
    }










































    public function getReporteExcel($filtroBusqueda, $sucursal, $fechaInicial, $fechaFinal)
    {
        $numeroDeFila = 9;

        $sucursal = (session('sucursalSession') == 'TODOS' || session('rolSession') != 'USUARIO') ? $sucursal : session('sucursalSession');
        $datosSucursal = Sucursale::where('sucursal', $sucursal)->get();

        $tablaSucursal = "registro_movimientos_" . strtolower($sucursal);
        $tableRegistros = new RegistroMovimientos();
        $tableRegistros->setTable($tablaSucursal);

        if ($filtroBusqueda != "TODOS") {
            $consultaRegistros = $tableRegistros
                ->where(function ($query) use ($filtroBusqueda) {
                    $query->where('codigo_producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('producto', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_dist', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('denominacion_gen', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('cedula', 'LIKE', '%' . $filtroBusqueda . '%')
                        ->orWhere('factura', 'LIKE', '%' . $filtroBusqueda . '%');
                })
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        } else if ($filtroBusqueda == "TODOS") {
            $consultaRegistros = $tableRegistros
                ->whereBetween('fecha', [$fechaInicial, $fechaFinal])
                ->orderBy('id', 'asc')
                ->get();
        }

        $jsonDatos = json_encode($consultaRegistros);

        $reporte = new Spreadsheet();
        $reporte
            ->getProperties()
            ->setCreator("Grupo Farmaceutico del Carmen")
            ->setTitle('Regstros del libro de antibiotico')
            ->setDescription('Registro del libro de antibiotico');

        $reporte->getDefaultStyle()->getFont()->setName('Calibri');

        $hojaDeRegistros = $reporte->getActiveSheet();
        $hojaDeRegistros->setTitle("del libro de antibiotico");

        //Inserta el logo en el reporte
        $drawing = new Drawing();
        $drawing->setPath('../public/images/reportes/logo.jpg');
        $drawing->setCoordinates('A2');
        $drawing->setWidth(220);
        $drawing->setOffsetX(15);
        $drawing->getShadow()->setVisible(true);
        $drawing->getShadow()->setDirection(45);
        $drawing->setWorksheet($hojaDeRegistros);

        //Se Combina las celdas para el titulo del reporte
        $hojaDeRegistros->mergeCells("C2:H5");

        //Titulo del reporte
        $titulo = $datosSucursal[0]->tipo == 'SURTIDORA' ? "SURTIDORA MEDICA DEL CARMEN - SUCURSAL " : "FARMACIAS DEL CARMEN - SUCURSAL ";
        $hojaDeRegistros->setCellValue("C2", $titulo . $datosSucursal[0]->nombre);

        //Se establece el estilo de las celdas del titulo
        $hojaDeRegistros->getStyle('C2')->getFont()->setSize(18);
        $hojaDeRegistros->getStyle('C2')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
        $hojaDeRegistros->getStyle('C2')->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
        $hojaDeRegistros->getStyle('C2')->getFont()->setBold(true);

        //Se define el nombre de las columnas
        $encabezado = ["#", "FECHA", "CODIGO PRODUCTO", "PRODUCTO", "DENOMINACIÓN DISTINTIVA", "DENOMINACIÓN GENÉRICA", "PRESENTACIÓN", "LABORATORIO", "PROCEDENCIA", "NOMBRE DE QUIEN PRESCRIBE", "DOMICILIO", "CEDULA PROFESIONAL", "NÚMERO DE FACTURA", "NÚMERO DE RECETA", "CANTIDAD ADQUIRIDA", "CANTIDAD VENDIDA", "SALDO", "OBSERVACIONES"];

        //El último argumento es por defecto A1
        $hojaDeRegistros->fromArray($encabezado, null, 'A8');

        //dd($consultaRegistros->toJson(JSON_PRETTY_PRINT));
        $data = json_decode($jsonDatos, true);

        //dd($data);
        //Se recorre el JSON para obtener los datos de cada registro y colocarlos en la hoja de excel
        foreach ($data as  $dataRegistro) {
            //Se inserta los datos en la hoja de excel
            $hojaDeRegistros->setCellValueByColumnAndRow(1, $numeroDeFila, $dataRegistro['id']);
            $hojaDeRegistros->setCellValueByColumnAndRow(2, $numeroDeFila, $dataRegistro['fecha']);
            $hojaDeRegistros->setCellValueByColumnAndRow(3, $numeroDeFila, $dataRegistro['codigo_producto']);
            $hojaDeRegistros->setCellValueByColumnAndRow(4, $numeroDeFila, $dataRegistro['producto']);
            $hojaDeRegistros->setCellValueByColumnAndRow(5, $numeroDeFila, $dataRegistro['denominacion_dist']);
            $hojaDeRegistros->setCellValueByColumnAndRow(6, $numeroDeFila, $dataRegistro['denominacion_gen']);
            $hojaDeRegistros->setCellValueByColumnAndRow(7, $numeroDeFila, $dataRegistro['presentacion']);
            $hojaDeRegistros->setCellValueByColumnAndRow(8, $numeroDeFila, $dataRegistro['laboratorio']);
            $hojaDeRegistros->setCellValueByColumnAndRow(9, $numeroDeFila, $dataRegistro['procedencia']);
            $hojaDeRegistros->setCellValueByColumnAndRow(10, $numeroDeFila, $dataRegistro['nombre_pree']);
            $hojaDeRegistros->setCellValueByColumnAndRow(11, $numeroDeFila, $dataRegistro['domicilio']);
            $hojaDeRegistros->setCellValueByColumnAndRow(12, $numeroDeFila, $dataRegistro['cedula']);
            $hojaDeRegistros->setCellValueByColumnAndRow(13, $numeroDeFila, $dataRegistro['factura']);
            $hojaDeRegistros->setCellValueByColumnAndRow(14, $numeroDeFila, $dataRegistro['receta']);
            $hojaDeRegistros->setCellValueByColumnAndRow(15, $numeroDeFila, $dataRegistro['cantidad_adquirida']);
            $hojaDeRegistros->setCellValueByColumnAndRow(16, $numeroDeFila, $dataRegistro['cantidad_vendida']);
            $hojaDeRegistros->setCellValueByColumnAndRow(17, $numeroDeFila, $dataRegistro['saldo']);
            $hojaDeRegistros->setCellValueByColumnAndRow(18, $numeroDeFila, $dataRegistro['observaciones']);

            $colorCelda =  $dataRegistro['tipo_movimiento'] == 'ENTRADA' ? 'E1FFD2' : 'FFD2D2';
            $hojaDeRegistros->getStyle('A' . $numeroDeFila . ':R' . $numeroDeFila . '')->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB($colorCelda);

            //Cada vez que se recorre el JSON se aumenta el número de fila, para que se puedan insertar los siguientes datos
            $numeroDeFila++;
        }

        //Se asgina el estilo de los borders a las celdas
        $reporte
            ->getActiveSheet()
            ->getStyle('A8:R' . $numeroDeFila . '')
            ->getBorders()
            ->getAllBorders()
            ->setBorderStyle(Border::BORDER_MEDIUM)
            ->setColor(new Color('0000'));

        //Se colocan los titulos de las columnas en negrita
        $hojaDeRegistros->getStyle('A8:R8')->getFont()->setBold(true);

        //Se encarga de asignar el tamano de las columnas
        foreach (range('A', 'R') as $columnID) {

            if ($columnID == "C") {
                $hojaDeRegistros->getColumnDimension('C')->setWidth(25.30);
            } else {
                $hojaDeRegistros->getColumnDimension($columnID)->setAutoSize(true);
            }
        }

        //Se declara el estilio de la fuente del archivo
        $hojaDeRegistros->getStyle('A8:R8')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
        $hojaDeRegistros->getStyle('A8:R8')->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('FFD483');
        $hojaDeRegistros->getStyle('A9:R' . $numeroDeFila . '')->getAlignment()->setWrapText(true)->setHorizontal(Alignment::HORIZONTAL_LEFT);
        $hojaDeRegistros->getStyle('A9:R' . $numeroDeFila . '')->getFont()->setSize(10);

        //Se asgina el formato de los codigos de producto
        $hojaDeRegistros->getStyle('C9:C' . $numeroDeFila . '')->getNumberFormat()->setFormatCode('######################');


        //Alamcenamos el nombre del archivo en una variable
        $fileName = "Reporte_libro_antibiotico_" . $sucursal . "_" . $fechaInicial . "_" . $fechaFinal . ".xlsx";

        ob_start();

        //Guardamos el archivo en la carpeta de reportes
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
        $writer = new Xlsx($reporte);
        $writer->save('php://output');

        $xlsData = ob_get_contents();
        ob_end_clean();

        Log::info("Reporte de la sucursal [" . $sucursal . "] exportado en excel exitosamente");

        return Response()->json(["success" => true, 'nameFile' => $fileName, 'file' => "data:application/vnd.ms-Excel;base64," . base64_encode($xlsData)]);
    }
}
