<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;

class ValidaKeyTerminal
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {

        if (Auth::user()->privilegio == "CAJERO") {
            $idUsuario = Auth::user()->id;

            $queryUsuarioCliente = DB::table('usuarios_agentes')
                ->select('usuarios_agentes.id_usuario', 'terminales.terminal')
                ->join('terminales', 'terminales.id', '=', 'usuarios_agentes.id_estacion')
                ->where('id_usuario', $idUsuario)
                ->get();

            if (!empty($queryUsuarioCliente[0])) {
                session(['terminalSession' => $queryUsuarioCliente[0]->terminal]);

                return $next($request);
            } else {
                $tituloError = "INCIO DE SESION";
                $mensajeError = "AL PARECER NO HAS INICIADO SESION EN EL CLIENTE DE LA ESTACION";

                //Recupera la sucursal, terminal y usuario de quienesta intentando acceder
                //Guardamos los datos en un array
                $arrayDatos = [
                    'fecha/hora' => date('Y-m-d H:i:s'),
                    'username' => session('nombreUsuarioSession'),
                    'terminal' => session('terminalSession'),
                    'mensaje' => $mensajeError,
                    'user_agent' => $request->header('User-Agent'),
                    'url' => $request->fullUrl() . ' [' . $request->method() . ']',
                ];

                //Guardamos los datos en un archivo de log
                Log::withContext($arrayDatos)->error("El usuario no ha iniciado sesion en el cliente [" . session('nombreUsuarioSession') . "]");
                return response()->view('errors.511', compact('mensajeError', 'tituloError'), 511);
            }
        } else {
            return $next($request);
        }
    }
}
