<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubCategoriasPermisosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('c_sub_categorias_permisos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('id_categoria')->unsigned()->nullable();
            $table->foreign('id_categoria')->references("id")
            ->on("c_categorias_permisos")
            ->onDelete("cascade")
            ->onUpdate("cascade");
            $table->string('sub_categoria', 100);
            $table->integer('activo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('c_sub_categorias_permisos');
    }
}
