$(document).ready(function() {
    $.fn.dataTable.ext.errMode = 'throw';
    $(function() {
        $('#cp-table').DataTable({
            destroy: true,
            "language": {
                "info": "_TOTAL_ Registros",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            }
        });
        $("#gen_table").validate({
            debug: false,
            event: "blur",
            errorElement: "label",
    
            rules: {
                bus_estado: {
                    required: true
                },
                bus_municipio: {
                    required: true
                }
            },
            messages: {
                bus_estado: {
                    required: "Favor de selecionar un Estado",
                },
                bus_municipio: {
                    required: "Favor de selecionar un Municipio",
                }
            },
    
            submitHandler: function(form, e) {
                e.preventDefault();
                //form.submit();

                    var table = $('#cp-table').DataTable();
                    table.clear().draw();
                    var estado = $('#bus_estado').val();
                    var municipio = $('#bus_municipio').val();
    
                    $.fn.dataTable.ext.errMode = 'throw';
                    $('#cp-table').DataTable({
                        processing: true,
                        serverSide: false,
                        destroy: true,
                        responsive: true,
                        ajax: route('configuraciones.catalogos.cp_data', {estado,municipio}),
                        columns: [
                            {
                                data: 'id_cp',
                                name: 'id_cp'
                            },
                            {
                                data: 'cp',
                                name: 'cp'
                            },
                            {
                                data: 'tipo_asentamiento',
                                name: 'tipo_asentamiento'
                            },
                            {
                                data: 'estado',
                                name: 'estado'
                            },
                            {
                                data: 'municipio',
                                name: 'municipio'
                            },
                            {
                                data: 'ciudad',
                                name: 'ciudad'
                            },
                            {
                                data: 'colonia',
                                name: 'colonia'
                            },
                            { data: 'action', name: 'action', orderable: false, searchable: false }
                        ],
                        "language": {
                            "info": "_TOTAL_ Registros",
                            "search": "Buscar",
                            "paginate": {
                                "next": "Siguiente",
                                "previous": "Anterior",
                            },
                            "lengthMenu": '_MENU_ Registros',
                            "loadingRecords": "Cargando...",
                            "processing": "Procesando...",
                            "emptyTable": "SIN REGISTROS",
                            "zeroRecords": "SIN REGISTROS",
                            "infoEmpty": "",
                            "infoFiltered": "",
                        }
                    });
            }
        });
                $("#gen_table").validate({
            debug: false,
            event: "blur",
            errorElement: "label",
    
            rules: {
                bus_estado: {
                    required: true
                },
                bus_municipio: {
                    required: true
                }
            },
            messages: {
                bus_estado: {
                    required: "Favor de selecionar un Estado",
                },
                bus_municipio: {
                    required: "Favor de selecionar un Municipio",
                }
            },
    
            submitHandler: function(form, e) {
                e.preventDefault();
                //form.submit();

                    var table = $('#cp-table').DataTable();
                    table.clear().draw();
                    var estado = $('#bus_estado').val();
                    var municipio = $('#bus_municipio').val();
    
                    $.fn.dataTable.ext.errMode = 'throw';
                    $('#cp-table').DataTable({
                        processing: true,
                        serverSide: false,
                        destroy: true,
                        responsive: true,
                        ajax: route('configuraciones.catalogos.cp_data', {estado,municipio}),
                        columns: [
                            {
                                data: 'id_cp',
                                name: 'id_cp'
                            },
                            {
                                data: 'cp',
                                name: 'cp'
                            },
                            {
                                data: 'tipo_asentamiento',
                                name: 'tipo_asentamiento'
                            },
                            {
                                data: 'estado',
                                name: 'estado'
                            },
                            {
                                data: 'municipio',
                                name: 'municipio'
                            },
                            {
                                data: 'ciudad',
                                name: 'ciudad'
                            },
                            {
                                data: 'colonia',
                                name: 'colonia'
                            },
                            { data: 'action', name: 'action', orderable: false, searchable: false }
                        ],
                        "language": {
                            "info": "_TOTAL_ Registros",
                            "search": "Buscar",
                            "paginate": {
                                "next": "Siguiente",
                                "previous": "Anterior",
                            },
                            "lengthMenu": '_MENU_ Registros',
                            "loadingRecords": "Cargando...",
                            "processing": "Procesando...",
                            "emptyTable": "SIN REGISTROS",
                            "zeroRecords": "SIN REGISTROS",
                            "infoEmpty": "",
                            "infoFiltered": "",
                        }
                    });
            }
        });
    });
    $("#form_registro").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            estado_2: {
                required: true
            },
            muni_2: {
                required: true
            },
            colonia: {
                required: true
            },
            ciudad: {
                required: true
            },
            tipo_asent: {
                required: true
            },
            cp: {
                required: true
            }
           
        },
        messages: {
            estado_2: {
                required: "Favor de selecionar un Estado",
            },
            muni_2: {
                required: "Favor de selecionar un Municipio",
            },
            colonia: {
                required: "Favor de ingresar una Colonia",
            },
            ciudad: {
                required: "Favor de ingresar una Ciudad",
            },
            tipo_asent: {
                required: "Favor de ingresar un Tipo de Asentamiento",
            },
            cp: {
                required: "Favor de ingresar un Código Poastal",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            //form.submit();
            
            const formularioData = new FormData(form);
            $("#registro_succes").prop('disabled', true);
            $.ajax({
                url: route('configuraciones.catalogos.cp_guardar'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,

                success: function (data) {
                    $("#btn_cerrar_notificacion").attr("onclick","reload_pag();");
                    let mensaje = data.mensaje;
                    modalSuccess(mensaje);
                },
                error: function (request, status) {
                    let mensaje = request.responseJSON.error;
                    let icon = request.responseJSON.icon;
                    modalError(mensaje, icon);
                    $("#registro_succes").prop('disabled', false);
                }

            });
            
        }
    });
});
function bus_muni(){
    if($('#bus_estado').val()!="0"){
        var estado = $('#bus_estado').val();
        $.ajax({
            type:'GET',
            url: route('configuraciones.catalogos.comprobar_cp', estado),
            success: function(respuesta){
               
            },
            error: function (){
                let mensaje = request.responseJSON.error;
                let icon = request.responseJSON.icon;
                modalError(mensaje, icon);
            }
        }).done(function (data) {
            $('#bus_municipio option').remove();
            $('#bus_municipio').append('<option value="0">Todos</option>');
            data.municipio.forEach(function (data2) {
                $('#bus_municipio').append('<option value="' + data2.municipio + '">' + data2.municipio + '</option>');
            });
        });
    }
    else{
        $('#bus_municipio option').remove();
        $('#bus_municipio').append('<option value="0">Todos</option>');
    }
}
function bus_muni_2(){
    if($('#estado_2').val()!="0"){
        var estado = $('#estado_2').val();
        $.ajax({
            type:'GET',
            url: route('configuraciones.catalogos.comprobar_cp', estado),
            success: function(respuesta){
               
            },
            error: function (){
                let mensaje = request.responseJSON.error;
                let icon = request.responseJSON.icon;
                modalError(mensaje, icon);
            }
        }).done(function (data) {
            $('#muni_2 option').remove();
            $('#muni_2').append('<option value="">Seleccione un Municipio</option>');
            data.municipio.forEach(function (data2) {
                $('#muni_2').append('<option value="' + data2.municipio + '">' + data2.municipio + '</option>');
            });
        });
    }
    else{
        $('#muni_2 option').remove();
        $('#muni_2').append('<option value="">Seleccione un Municipio</option>');
    }
}
function bus_muni_3(){
    if($('#bus_estado').val()!=""){
        $('#estado_2').val($('#bus_estado').val());
        var estado = $('#estado_2').val();
        $.ajax({
            type:'GET',
            url: route('configuraciones.catalogos.comprobar_cp', estado),
            success: function(respuesta){
               
            },
            error: function (){
                let mensaje = request.responseJSON.error;
                let icon = request.responseJSON.icon;
                modalError(mensaje, icon);
            }
        }).done(function (data) {
            $('#muni_2 option').remove();
            $('#muni_2').append('<option value="">Seleccione un Municipio</option>');
            data.municipio.forEach(function (data2) {
                $('#muni_2').append('<option value="' + data2.municipio + '">' + data2.municipio + '</option>');
            });
            if($('#bus_municipio').val()!="0"){ $('#muni_2').val($('#bus_municipio').val()); }
        });
    }
    else{
        $('#estado_2').val("");
        $('#muni_2 option').remove();
        $('#muni_2').append('<option value="">Seleccione un Municipio</option>');
    }
}
function editar(data){
    $("#estado_2").val(data.estado);
    var estado = $('#estado_2').val();
    $.ajax({
        type:'GET',
        url: route('configuraciones.catalogos.comprobar_cp', estado),
        success: function(respuesta){
           
        },
        error: function (){
            let mensaje = request.responseJSON.error;
            let icon = request.responseJSON.icon;
            modalError(mensaje, icon);
        }
    }).done(function (data3) {
        $('#muni_2 option').remove();
        $('#muni_2').append('<option value="">Seleccione un Municipio</option>');
        data3.municipio.forEach(function (data2) {
            $('#muni_2').append('<option value="' + data2.municipio + '">' + data2.municipio + '</option>');
        });
        $('#muni_2').val(data.municipio);
    });
    $("#colonia").val(data.colonia);
    $("#ciudad").val(data.ciudad);
    $("#tipo_asent").val(data.tipo_asentamiento);
    $("#cp").val(data.cp);
    $('#Reg').val(data.id_cp);

    $('#registro_succes').html('Editar'); $('#registro_succes').removeClass('btn-primary-fit-modal'); $('#registro_succes').addClass('btn-warning-fit-modal');
}
function limpiaModal(){
    $('#estado_2').val("");
    $('#colonia').val("");
    $('#Reg').val("");
    $('#ciudad').val("");
    $('#tipo_asent').val("");
    $('#cp').val("");
    $('#muni_2 option').remove();
    $('#muni_2').append('<option value="">Seleccione un Municipio</option>');

    $('#registro_succes').html('Agregar'); $('#registro_succes').removeClass('btn-warning-fit-modal'); $('#registro_succes').addClass('btn-primary-fit-modal');
}
//Funcion que manda a llamar al modal que se le pase como paramentro
function toggleModal($modal) {
    var body = document.querySelector('body');
    var modal = document.querySelector('#' + $modal);
    modal.classList.toggle('opacity-0');
    modal.classList.toggle('pointer-events-none');
    body.classList.toggle('modal-active');
}

//Iniciar Modals de alerta
function modalError($mensaje, $icon) {
    $('#btn-aceptar').hide();
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el error
    $('#imagen-notificacion').attr('src', '../../../images/modal/'+$icon+'.png');
    toggleModal("notificacion");
}
function modalSuccess($mensaje) {
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el mensaje de exito
    $('#imagen-notificacion').attr('src', '../../../images/modal/success.png');
    toggleModal("notificacion"); //ocultamos el modal del registro
}
//reload function
function reload_pag(){
    window.location.reload();
}