$(document).ready(function() {
    $(function() {
        $('#productos-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.catalogos.productos_data'),
            columns: [{
                    data: 'id_producto',
                    name: 'id_producto'
                },
                {
                    data: 'codigo_producto',
                    name: 'codigo_producto'
                },

                {
                    data: 'producto',
                    name: 'producto'
                },
                {
                    data: 'linea',
                    name: 'linea'
                },
                {
                    data: 'marca',
                    name: 'marca'
                },
                {
                    data: 'pcosto',
                    name: 'pcosto'
                },
                {
                    data: 'pventa1',
                    name: 'pventa1'
                },
                {
                    data: 'lote',
                    name: 'lote'
                },
                {
                    data: 'caducidad',
                    name: 'caducidad'
                },
                {
                    data: 'existencia',
                    name: 'existencia'
                },
                {
                    data: 'costo',
                    name: 'costo'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function(data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Productos",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });
    $("#form_registro").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            codigo: {
                required: true
            },
            producto: {
                required: true
            },
            liena: {
                required: true
            },
            marca: {
                required: true
            },
            pcosto: {
                required: true
            },
            pventa: {
                required: true
            },
            stockmaximo: {
                required: true
            },
            stockminimo: {
                required: true
            },
            lote: {
                required: true
            },
            caducidad: {
                required: true
            },
            existencia: {
                required: true
            },
            costo: {
                required: true
            },
            unidads: {
                required: true
            },
            claves: {
                required: true
            }
           
        },
        messages: {
            codigo: {
                required: "Favor de ingresar un código de producto",
            },
            producto: {
                required: "Favor de ingresar la descripción del producto",
            },
            liena: {
                required: "Favor de ingresar la línea del producto",
            },
            marca: {
                required: "Favor de ingresar la marca del producto",
            },
            pcosto: {
                required: "Favor de ingresar el costo del producto",
            },
            pventa: {
                required: "Favor de ingresar el costo de venta del producto",
            },
            stockmaximo: {
                required: "Favor de ingresar un valor de stock máximo para el producto",
            },
            stockminimo: {
                required: "Favor de ingresar un valor de stock mínimo para el producto",
            },
            lote: {
                required: "Favor de ingresar un número de lote para el procucto",
            },
            caducidad: {
                required: "Favor de seleccionar una fecha de caducidad del producto",
            },
            existencia: {
                required: "Favor de ingresar un valor de existencia de producto",
            },
            costo: {
                required: "Favor de ingresar el costo del producto",
            },
            unidads: {
                required: "Favor de ingresar la unidad SAT para el producto",
            },
            claves: {
                required: "Favor de ingresar la clave SAT para el producto",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            //form.submit();
            
            const formularioData = new FormData(form);
            $("#registro_succes").prop('disabled', true);
            $.ajax({
                url: route('configuraciones.catalogos.productos_guardar'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,

                success: function (data) {
                    $("#btn_cerrar_notificacion").attr("onclick","reload_pag();");
                    let mensaje = data.mensaje;
                    modalSuccess(mensaje);
                },
                error: function (request, status) {
                    let mensaje = request.responseJSON.error;
                    let icon = request.responseJSON.icon;
                    modalError(mensaje, icon);
                    $("#registro_succes").prop('disabled', false);
                }

            });
            
        }
    });
});
function limpiaModal(){
    $('#codigo').val('');
    $('#producto').val('');
    $('#liena').val('');
    $('#marca').val('');
    $('#pcosto').val('');
    $('#pventa').val('');
    $('#stockmaximo').val('');
    $('#stockminimo').val('');
    $('#lote').val('');
    $('#caducidad').val('');
    $('#existencia').val('');
    $('#costo').val('');
    $('#unidads').val('');
    $('#claves').val('');
    $('#Reg').val('');
    
    $('#registro_succes').html('Agregar'); $('#registro_succes').removeClass('btn-warning-fit-modal'); $('#registro_succes').addClass('btn-primary-fit-modal');

    $("#impuesto").prop("checked", false);
    $("#activo").prop("checked", true);
}
function editar(data){
    $('#codigo').val(data.codigo_producto);
    $('#producto').val(data.producto);
    $('#liena').val(data.linea);
    $('#marca').val(data.marca);
    $('#pcosto').val(data.pcosto);
    $('#pventa').val(data.pventa1);
    $('#stockmaximo').val(data.stockmaximo);
    $('#stockminimo').val(data.stockminimo);
    $('#lote').val(data.lote);
    $('#caducidad').val(data.caducidad);
    $('#existencia').val(data.existencia);
    $('#costo').val(data.costo);
    $('#unidads').val(data.unidad_sat);
    $('#claves').val(data.clave_sat);
    $('#Reg').val(data.id_producto);

    $('#registro_succes').html('Editar'); $('#registro_succes').removeClass('btn-primary-fit-modal'); $('#registro_succes').addClass('btn-warning-fit-modal');

    if(data.impuesto =="SI") { $("#impuesto").prop("checked", true); } else if(data.impuesto =="NO"){ $("#impuesto").prop("checked", false); }
    if(data.activo ==1) { $("#activo").prop("checked", true); } else if(data.activo ==0){ $("#activo").prop("checked", false); }
}
//Funcion que manda a llamar al modal que se le pase como paramentro
function toggleModal($modal) {
    var body = document.querySelector('body');
    var modal = document.querySelector('#' + $modal);
    modal.classList.toggle('opacity-0');
    modal.classList.toggle('pointer-events-none');
    body.classList.toggle('modal-active');
}

//Iniciar Modals de alerta
function modalError($mensaje, $icon) {
    $('#btn-aceptar').hide();
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el error
    $('#imagen-notificacion').attr('src', '../../../images/modal/'+$icon+'.png');
    toggleModal("notificacion");
}
function modalSuccess($mensaje) {
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el mensaje de exito
    $('#imagen-notificacion').attr('src', '../../../images/modal/success.png');
    toggleModal("notificacion"); //ocultamos el modal del registro
}
//reload function
function reload_pag(){
    window.location.reload();
}