$(document).ready(function() {
    $(function() {
        $('#tiempo-validado-comoras-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.catalogos.tiempo_validado_compras_data'),
            columns: [{
                    data: 'id_validado',
                    name: 'id_validado'
                },
                {
                    data: 'concepto',
                    name: 'concepto'
                },

                {
                    data: 'tiempo_regalo',
                    name: 'tiempo_regalo'
                },
                {
                    data: 'tiempo_minimo',
                    name: 'tiempo_minimo'
                },
                {
                    data: 'monto_minimo',
                    name: 'monto_minimo'
                },
                {
                    data: 'monto_maximo',
                    name: 'monto_maximo'
                },
                {
                    data: 'cobro_regalo',
                    name: 'cobro_regalo'
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Registros",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });
    const moonLanding = new Date();
    $("#form_registro").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            concepto: {
                required: true
            },
            tiempo_regalo: {
                required: true
            },
            tiempo_minimo: {
                required: true
            },
            monto_minimo: {
                required: true
            },
            monto_maximo: {
                required: true
            },
            cobro_regalo: {
                required: true
            }
           
        },
        messages: {
            concepto: {
                required: "Favor de ingresar un concepto",
            },
            tiempo_regalo: {
                required: "Favor de ingresar un tiempo de regalo",
            },
            tiempo_minimo: {
                required: "Favor de ingresar un tiempo mínimo",
            },
            monto_minimo: {
                required: "Favor de ingresar un monto mínimo",
            },
            monto_maximo: {
                required: "Favor de ingresar un monto máximo",
            },
            cobro_regalo: {
                required: "Favor de ingresar una cantidad de regalo",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            //form.submit();
            
            const formularioData = new FormData(form);
            $("#registro_succes").prop('disabled', true);
            $.ajax({
                url: route('configuraciones.catalogos.tiempo_validado_compra_guardar'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,

                success: function (data) {
                    $("#btn_cerrar_notificacion").attr("onclick","reload_pag();");
                    let mensaje = data.mensaje;
                    modalSuccess(mensaje);
                },
                error: function (request, status) {
                    let mensaje = request.responseJSON.error;
                    let icon = request.responseJSON.icon;
                    modalError(mensaje, icon);
                    $("#registro_succes").prop('disabled', false);
                }

            });
            
        }
    });
});
function limpiaModal(){
    $('#concepto').val("");
    $('#tiempo_regalo').val("");
    $('#tiempo_minimo').val("");
    $('#monto_minimo').val("");
    $('#monto_maximo').val("");
    $('#cobro_regalo').val("");
    $('#Reg').val('');
    
    $('#registro_succes').html('Agregar'); $('#registro_succes').removeClass('btn-warning-fit-modal'); $('#registro_succes').addClass('btn-primary-fit-modal');
}
function editar(data){

    $('#concepto').val(data.concepto);
    $('#tiempo_regalo').val(data.tiempo_regalo);
    $('#tiempo_minimo').val(data.tiempo_minimo);
    $('#monto_minimo').val(data.monto_minimo);
    $('#monto_maximo').val(data.monto_maximo);
    $('#cobro_regalo').val(data.cobro_regalo);
    $('#Reg').val(data.id_validado);

    $('#registro_succes').html('Editar'); $('#registro_succes').removeClass('btn-primary-fit-modal'); $('#registro_succes').addClass('btn-warning-fit-modal');
}
//Funcion que manda a llamar al modal que se le pase como paramentro
function toggleModal($modal) {
    var body = document.querySelector('body');
    var modal = document.querySelector('#' + $modal);
    modal.classList.toggle('opacity-0');
    modal.classList.toggle('pointer-events-none');
    body.classList.toggle('modal-active');
}

//Iniciar Modals de alerta
function modalError($mensaje, $icon) {
    $('#btn-aceptar').hide();
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el error
    $('#imagen-notificacion').attr('src', '../../../images/modal/'+$icon+'.png');
    toggleModal("notificacion");
}
function modalSuccess($mensaje) {
    $("#mensaje-notificacion").text("");
    $("#mensaje-notificacion").text($mensaje); //Mostramos el mensaje de exito
    $('#imagen-notificacion').attr('src', '../../../images/modal/success.png');
    toggleModal("notificacion"); //ocultamos el modal del registro
}
//reload function
function reload_pag(){
    window.location.reload();
}