$(document).ready(function () {
    $(function () {
        $('#permisos-categorias-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.permisos.categorias.categorias_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'categoria',
                    name: 'categoria'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function (data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    width: '20%'
                }
            ],
            "language": {
                "info": "_TOTAL_ Categorias",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },

            fnDrawCallback: function (oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });

    $("#form_agrega_categoria_permiso").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_categoria_permiso: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            estado: {
                required: true,
            }
        },
        messages: {
            nombre_categoria_permiso: {
                required: "Favor de ingresar un nombre para la categoria",
                minlength: "La categoria debe tener al menos 3 caracteres",
                maxlength: "La categoria debe tener como máximo 100 caracteres"
            },
            estado: {
                required: "Favor de seleccionar un estado"
            }
        },

        submitHandler: function (form, e) {
            e.preventDefault();
            form.submit();
            $("#btn_agregar_catego").prop('disabled', true);
        }
    });

    $("#form_actualizar_categoria").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_categoria_edit: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            estado_edit: {
                required: true,
            }
        },
        messages: {
            nombre_categoria_edit: {
                required: "Favor de ingresar un nombre para la categoria",
                minlength: "La categoria debe tener al menos 3 caracteres",
                maxlength: "La categoria debe tener como máximo 100 caracteres"
            },
            estado_edit: {
                required: "Favor de seleccionar un estado"
            }
        },

        submitHandler: function (form, e) {
            e.preventDefault();
            form.submit();
            $("#btn_actualiza_catego").prop('disabled', true);
        }
    });

    $("#categoria").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_categoria_edit: {
                required: true
            }
        },
        messages: {
            nombre_categoria_edit: {
                required: "Favor de ingresar un nombre para la categoria"
            }
        },

        submitHandler: function (form, e) {
            e.preventDefault();
            form.submit();
            $("#btn_elimina_catego").prop('disabled', true);
        }
    });

    $(document).on("click", ".btn-actuliza-categoria", function () {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function () {
                $("#estado_edit option:selected").removeAttr("selected");
            },
            success: function (request) {

                $('#id_categoria_edit').val(request.data.id);
                $("#nombre_categoria_edit").val(request.data.categoria);

                $("#estado_edit > option[value = '" + request.data.activo + "']").attr("selected", true);
            }
        });
    });

    $(document).on("click", ".btn-elimina-categoria", function () {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,
            success: function (data) {
                $("#mensaje-notificacion").text("¿Desea eliminar la categoria " + data.data.categoria + "?");
                $("#id_categoria_destroy").val(data.data.id);
                toggleModal("confirma-elimina-categoria");
            }
        });
    });

    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
