$(document).ready(function() {
    $(function() {
        $('#permisos-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.permisos.permisos_data'),
            columns: [
                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'categoria',
                    name: 'categoria'
                },
                {
                    data: 'sub_categoria',
                    name: 'sub_categoria'
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Permisos",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });

    $("#categoria").change(function() {
        let idCategoria = $('select[id=categoria]').val();
        $.ajax({
            url: route('configuraciones.permisos.subcategorias_data', idCategoria),
            type: 'GET',
            beforeSend: function() {
                $("#subCategoria").empty();
                $('#subCategoria').append('<option value="">SELECIONE UNA SUBCATEGORIA</option>');
            },
            success: function(request) {
                request.data.forEach(function(data) {
                    $('#subCategoria').append('<option value="' + data.id + '">' + data.sub_categoria + '</option>');
                });
            }
        });
    });

    $("#categoria_edit").change(function() {
        let idCategoria = $('select[id=categoria_edit]').val();
        $.ajax({
            url: route('configuraciones.permisos.subcategorias_data', idCategoria),
            type: 'GET',
            beforeSend: function() {
                $("#subCategoria_edit").empty();
                $('#subCategoria_edit').append('<option value="">SELECIONE UNA SUBCATEGORIA</option>');
            },
            success: function(request) {
                request.data.forEach(function(data) {
                    $('#subCategoria_edit').append('<option value="' + data.id + '">' + data.sub_categoria + '</option>');
                });
            }
        });
    });

    $("#form_agrega_permiso").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_permiso: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            descripcion_permiso: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            categoria: {
                required: true
            },
            subCategoria: {
                required: true
            }
        },
        messages: {
            nombre_permiso: {
                required: "Favor de ingresar un nombre para el permiso",
                minlength: "El permiso debe tener al menos 3 caracteres",
                maxlength: "El permiso debe tener como máximo 255 caracteres"
            },
            descripcion_permiso: {
                required: "Favor de ingresar una descripción para el permiso",
                minlength: "El permiso debe tener al menos 3 caracteres",
                maxlength: "El permiso debe tener como máximo 255 caracteres"
            },
            categoria: {
                required: "Favor de seleccionar una categoria"
            },
            subCategoria: {
                required: "Favor de seleccionar una subcategoria"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-agregar-permiso").prop('disabled', true);
        }
    });

    $("#form_actualizar_permiso").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_permiso_edit: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            descripcion_permiso_edit: {
                required: true,
                minlength: 3,
                maxlength: 255
            },
            categoria_edit: {
                required: true
            },
            subCategoria_edit: {
                required: true
            }
        },
        messages: {
            nombre_permiso_edit: {
                required: "Favor de ingresar un nombre para el permiso",
                minlength: "El permiso debe tener al menos 3 caracteres",
                maxlength: "El permiso debe tener como máximo 255 caracteres"
            },
            descripcion_permiso_edit: {
                required: "Favor de ingresar una descripción para el permiso",
                minlength: "El permiso debe tener al menos 3 caracteres",
                maxlength: "El permiso debe tener como máximo 255 caracteres"
            },
            categoria_edit: {
                required: "Favor de seleccionar una categoria"
            },
            subCategoria_edit: {
                required: "Favor de seleccionar una subcategoria"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-actualiza-permiso").prop('disabled', true);
        }
    });

    $("#form_elimina_permiso").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_permiso_edit: {
                required: true
            }
        },
        messages: {
            nombre_permiso_edit: {
                required: "Favor de ingresar un nombre para el permiso"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-eliminar-permiso").prop('disabled', true);
        }
    });

    $(document).on("click", ".btn-actuliza-permiso", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function() {
                $("#categoria_edit option:selected").removeAttr("selected");
            },
            success: function(data) {
                obtieneSubCategorias(data.data.id_category, data.data.id_sub_category);

                $('#id_permiso_edit').val(data.data.id);
                $("#nombre_permiso_edit").val(data.data.name);
                $("#descripcion_permiso_edit").val(data.data.description);

                $("#categoria_edit > option[value = '" + data.data.id_category + "']").attr("selected", true);


            }

        });
    });

    function obtieneSubCategorias(idCategoria, idSubCategoria) {

        $.ajax({
            url: route('configuraciones.permisos.subcategorias_data', idCategoria),
            type: 'GET',
            beforeSend: function() {
                $("#subCategoria_edit").prop('disabled', true);
                $("#subCategoria_edit").empty();
                $('#subCategoria_edit').append('<option value="">SELECCIONE UNA SUBCATEGORIA</option>');
            },
            success: function(request) {
                request.data.forEach(function(data) {
                    $('#subCategoria_edit').append('<option value="' + data.id + '">' + data.sub_categoria + '</option>');
                });

                $("#subCategoria_edit > option[value = '" + idSubCategoria + "']").attr("selected", true);
                $("#subCategoria_edit").prop('disabled', false);
            }
        });

    }

    $(document).on("click", ".btn-elimina-permiso", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#mensaje-notificacion").text("¿Desea eliminar el permiso " + data.data.name + "?");
                $("#id_permiso_destroy").val(data.data.id);
                toggleModal("confirma-elimina-permiso");
            }
        });
    });

    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
