$(document).ready(function() {
    $(function() {
        $('#permisos-subcategorias-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.permisos.subcategorias.subcategorias_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'categoria',
                    name: 'categoria'
                },
                {
                    data: 'sub_categoria',
                    name: 'sub_categoria'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function(data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                { data: 'action', name: 'action', orderable: false, searchable: false, width: '15%' }
            ],
            "language": {
                "info": "_TOTAL_ SubCategorias",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });

    $("#form_agrega_subcategoria").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_subcategoria: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            categoria: {
                required: true,
            },
            estado: {
                required: true,
            }
        },
        messages: {
            nombre_subcategoria: {
                required: "Favor de ingresar un nombre para la sub-categoria",
                minlength: "La csub-categoria debe tener al menos 3 caracteres",
                maxlength: "La sub-categoria debe tener como máximo 100 caracteres"
            },
            categoria: {
                required: "Favor de seleccionar una categoria",
            },
            estado: {
                required: "Favor de seleccionar un estado",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-agrega-subcate").prop('disabled', true);
        }
    });

    $("#form_actualizar_subcategoria").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_subcategoria: {
                required: true,
                minlength: 3,
                maxlength: 100
            },
            categoria: {
                required: true,
            },
            estado: {
                required: true,
            }
        },
        messages: {
            nombre_subcategoria_edit: {
                required: "Favor de ingresar un nombre para la sub-categoria",
                minlength: "La csub-categoria debe tener al menos 3 caracteres",
                maxlength: "La sub-categoria debe tener como máximo 100 caracteres"
            },
            categoria_edit: {
                required: "Favor de seleccionar una categoria",
            },
            estado_edit: {
                required: "Favor de seleccionar un estado",
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-actualiza-subcate").prop('disabled', true);
        }
    });

    $("#categoria").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            nombre_permiso_edit: {
                required: true
            }
        },
        messages: {
            nombre_permiso_edit: {
                required: "Favor de ingresar un nombre para el permiso"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-elimina-subcate").prop('disabled', true);
        }
    });

    $(document).on("click", ".btn-actuliza-subcategoria", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function() {
                //$("#categoria_edit option:selected").removeAttr("selected");
                $("#categoria_edit option:selected").removeAttr("selected");
                $("#estado_edit option:selected").removeAttr("selected");
            },
            success: function(request) {
                $('#id_subcategoria_edit').val(request.data.id);
                $("#nombre_subcategoria_edit").val(request.data.sub_categoria);
                $("#categoria_edit > option[value = '" + request.data.id_categoria + "']").attr("selected", true);
                $("#estado_edit > option[value = '" + request.data.activo + "']").attr("selected", true);
            }
        });
    });

    $(document).on("click", ".btn-elimina-subcategoria", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#mensaje-notificacion").text("¿Desea eliminar la subcategoria " + data.data.sub_categoria + "?");
                $("#id_subcategoria_destroy").val(data.data.id);
                toggleModal("confirma-elimina-subcategoria");
            }
        });
    });

    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
