$(document).ready(function() {
    $(function() {
        $('#users-table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            ajax: route('configuraciones.usuarios.usuarios_data'),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'username',
                    name: 'username'
                },

                {
                    data: 'nombre',
                    name: 'nombre'
                },
                {
                    data: 'ap_paterno',
                    name: 'ap_paterno'
                },
                {
                    data: 'ap_materno',
                    name: 'ap_materno'
                },
                {
                    data: 'privilegio',
                    name: 'privilegio'
                },
                {
                    data: 'sucursal_asignada',
                    name: 'sucursal_asignada'
                },
                {
                    data: 'activo',
                    name: 'activo',
                    render: function(data, type, row) {
                        if (data == 1) {
                            return '<span class="badge badge-success">SI</span>';
                        } else {
                            return '<span class="badge badge-danger">NO</span>';
                        }
                    }
                },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            "language": {
                "info": "_TOTAL_ Usuarios",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            },
            fnDrawCallback: function(oSettings) {
                if (oSettings._iDisplayLength > oSettings.fnRecordsDisplay()) {
                    $(oSettings.nTableWrapper).find('.dataTables_paginate').hide();
                    $(oSettings.nTableWrapper).find('.dataTables_length').hide();
                }
            }
        });
    });


    $(document).on("click", ".btn-actuliza-usuario", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,

            beforeSend: function() {
                //toggleModal("confirma-corte");
                $("#rol_edit option:selected").removeAttr("selected");
                $("#sucursal_edit option:selected").removeAttr("selected");
                $("#estado_edit option:selected").removeAttr("selected");
            },
            success: function(data) {
                $("#id_edit").val(data.data.id);
                $("#usuario_edit").val(data.data.username);
                $("#nombre_edit").val(data.data.nombre);
                $("#ap_paterno_edit").val(data.data.ap_paterno);
                $("#ap_materno_edit").val(data.data.ap_materno);

                $("#rol_edit > option[data = '" + data.data.privilegio + "']").attr("selected", true);
                $("#sucursal_edit > option[value = '" + data.data.sucursal_asignada + "']").attr("selected", true);
                $("#estado_edit > option[value = '" + data.data.activo + "']").attr("selected", true);
            }

        });
    });

    $(document).on("click", ".btn-elimina-usuario", function() {
        //Se recupera la ruta del boton
        const urlControlador = $(this).data("controller");

        //Se ejecuta el controlador por medio de ajax
        $.ajax({
            url: urlControlador,
            contentType: false,
            processData: false,
            success: function(data) {
                $("#mensaje-notificacion").text("¿Desea eliminar al usuario " + data.data.username + "?");
                $("#id_destroy").val(data.data.id);
                toggleModal("confirma-elimina-usuario");
            }
        });
    });

    //Se que los formularios tengan todos los campos requeridos
    $("#form_registra_usuario").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            usuario: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            password: {
                required: true,
                minlength: 6,
                maxlength: 20
            },
            nombre: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            ap_paterno: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            ap_materno: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            rol: {
                required: true,
            },
            sucursal: {
                required: true,
            },
            estado: {
                required: true,
            },
        },
        messages: {
            usuario: {
                required: "Favor de ingresar un usuario",
                minlength: "El usuario debe tener al menos 3 caracteres",
                maxlength: "El usuario debe tener como máximo 45 caracteres"
            },
            password: {
                required: "Favor de ingresar una contraseña",
                minlength: "La contraseña debe tener al menos 6 caracteres",
                maxlength: "ELa contraseña debe tener como máximo 20 caracteres"
            },
            nombre: {
                required: "Favor de ingresar un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres",
                maxlength: "El nombre debe tener como máximo 45 caracteres"
            },
            ap_paterno: {
                required: "Favor de ingresar un apellido paterno",
                minlength: "El apellido paterno debe tener al menos 3 caracteres",
                maxlength: "El apellido paterno  debe tener como máximo 45 caracteres"
            },
            ap_materno: {
                required: "Favor de ingresar un apellido materno",
                minlength: "El apellido materno debe tener al menos 3 caracteres",
                maxlength: "El apellido materno  debe tener como máximo 45 caracteres"
            },
            rol: {
                required: "Favor de seleccionar un rol",
            },
            sucursal: {
                required: "Favor de seleccionar una sucursal",
            },
            estado: {
                required: "Favor de seleccionar un estado",
            },
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-save-user").prop('disabled', true);
        }
    });

    $("#form_actuliza_usuario").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            usuario_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            password_edit: {
                minlength: 6,
                maxlength: 20
            },
            nombre_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            ap_paterno_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            ap_materno_edit: {
                required: true,
                minlength: 3,
                maxlength: 45
            },
            rol_edit: {
                required: true,
            },
            sucursal_edit: {
                required: true,
            },
            estado_edit: {
                required: true,
            },
        },
        messages: {
            usuario_edit: {
                required: "Favor de ingresar un usuario",
                minlength: "El usuario debe tener al menos 3 caracteres",
                maxlength: "El usuario debe tener como máximo 45 caracteres"
            },
            password_edit: {
                minlength: "La contraseña debe tener al menos 6 caracteres",
                maxlength: "ELa contraseña debe tener como máximo 20 caracteres"
            },
            nombre_edit: {
                required: "Favor de ingresar un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres",
                maxlength: "El nombre debe tener como máximo 45 caracteres"
            },
            ap_paterno_edit: {
                required: "Favor de ingresar un apellido paterno",
                minlength: "El apellido paterno debe tener al menos 3 caracteres",
                maxlength: "El apellido paterno  debe tener como máximo 45 caracteres"
            },
            ap_materno_edit: {
                required: "Favor de ingresar un apellido materno",
                minlength: "El apellido materno debe tener al menos 3 caracteres",
                maxlength: "El apellido materno  debe tener como máximo 45 caracteres"
            },
            rol_edit: {
                required: "Favor de seleccionar un rol",
            },
            sucursal_edit: {
                required: "Favor de seleccionar una sucursal",
            },
            estado_edit: {
                required: "Favor de seleccionar un estado",
            },
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-actualiza-user").prop('disabled', true);
        }
    });

    $("#form_elimina_usuario").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            id_destroy: {
                required: true
            }
        },
        messages: {
            id_destroy: {
                required: "Favor de ingresar un usuario"
            }
        },

        submitHandler: function(form, e) {
            e.preventDefault();
            form.submit();
            $("#btn-elimina-user").prop('disabled', true);
        }
    });


    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});