$(document).ready(function () {
    var sucursalFiltro = "";

    let idDelete = 0;
    let movimientoDelete = "";
    var tablaMovimientos = "";

    $('#btn_limpia_busca_movimientos').attr('disabled', true);

    function validaFormInicioBusqueda() {
        let errorFechaIni = $("#fecha_inicio").val() == "" ? "Favor de ingresar una fecha de inicio" : "";
        $("#fecha_inicio-error").text(errorFechaIni)

        let errorFechaFin = $("#fecha_fin").val() == "" ? "Favor de ingresar una fecha de fin" : "";
        $("#fecha_fin-error").text(errorFechaFin)

        let errorSucursal = $('option:selected', '#sucursal_ajuste').val() == "" ? "Favor de seleccionar una sucursal" : "";
        $("#sucursal_ajuste-error").text(errorSucursal)

        return (($('option:selected', '#sucursal_ajuste').val() != "") && ($("#fecha_inicio").val() != "") && ($("#fecha_fin").val() != ""));
    }

    function creaTablaNueva() {
        tablaMovimientos = $('#tabla_registros').DataTable({
            processing: true,
            responsive: true,
            destroy: true,
            searching: false,
            paginate: false,
            "language": {
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            }
        });
    }

    creaTablaNueva();

    function setTableData() {
        const sucursal = $('option:selected', '#sucursal_ajuste').val();
        const fechaInicio = $('#fecha_inicio').val();
        const fechaFinal = $('#fecha_fin').val();

        sucursalFiltro = sucursal;

        $('#fecha_inicio').attr('disabled', true);
        $('#fecha_fin').attr('disabled', true);
        $('#sucursal_ajuste').attr('disabled', true);
        $('#btn_busca_movimientos').attr('disabled', true);
        $('#btn_limpia_busca_movimientos').attr('disabled', false);

        var tablaMovimientos = $('#tabla_registros').DataTable({
            processing: true,
            responsive: true,
            destroy: true,
            ajax: route('ajusteMovimientos.getData', [sucursal, fechaInicio, fechaFinal]),
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'tipo_movimiento',
                    name: 'tipo_movimiento'
                },

                {
                    data: 'fecha',
                    name: 'fecha'
                },
                {
                    data: 'codigo_producto',
                    name: 'codigo_producto'
                },
                {
                    data: 'producto',
                    name: 'producto'
                },
                {
                    data: 'denominacion_dist',
                    name: 'denominacion_dist'
                },
                {
                    data: 'denominacion_gen',
                    name: 'denominacion_gen'
                },
                {
                    data: 'presentacion',
                    name: 'presentacion'
                },
                {
                    data: 'factura',
                    name: 'factura'
                },
                {
                    data: 'receta',
                    name: 'receta'
                },
                {
                    data: 'cantidad_adquirida',
                    name: 'cantidad_adquirida'
                },
                {
                    data: 'cantidad_vendida',
                    name: 'cantidad_vendida'
                },
                {
                    data: 'saldo',
                    name: 'saldo'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            "language": {
                "info": "_TOTAL_ Registros",
                "search": "Buscar",
                "paginate": {
                    "next": "Siguiente",
                    "previous": "Anterior",
                },
                "lengthMenu": '_MENU_ Registros',
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "emptyTable": "SIN REGISTROS",
                "zeroRecords": "SIN REGISTROS",
                "infoEmpty": "",
                "infoFiltered": "",
            }
        });

        $(document).on("click", "#btn_limpia_busca_movimientos", function () {
            $('#fecha_inicio').val("");
            $('#fecha_fin').val("");

            $('#fecha_inicio').attr('disabled', false);
            $('#fecha_fin').attr('disabled', false);
            $('#sucursal_ajuste').attr('disabled', false);
            $('#btn_busca_movimientos').attr('disabled', false);
            $('#btn_limpia_busca_movimientos').attr('disabled', true);

            sucursalFiltro = "";
            tablaMovimientos.clear().draw();
            tablaMovimientos.destroy();

            creaTablaNueva();
        });
    }

    $(document).on("click", "#btn_busca_movimientos", function () {

        if (validaFormInicioBusqueda()) {
            setTableData();
        }
    });


    function modalModificaEntrada(data) {
        $("#nombre_producto_entrada").text(data.producto);

        $("#id_edit").val(data.id);
        $("#denominacionDistEntrada").val(data.denominacion_dist);
        $("#denominacionGenEntrada").val(data.denominacion_gen);
        $("#presentacionEntrada").val(data.presentacion);
        $("#fechaEntrada").val(data.fecha);
        $("#procedenciaEntrada").val(data.procedencia);
        $("#domicilioEntrada").val(data.domicilio);
        $("#numFacturaEntrada").val(data.factura);
        $("#cantidadEntrada").val(data.cantidad_adquirida);
        $("#saldoEntrada").val(data.saldo);
        $("#observacionesEntrada").val(data.observaciones);

        toggleModal("modifica_registro_entrada");
    }

    function limpiaFormEntrada() {
        $("#nombre_producto_entrada").text("");

        $("#id_edit").val("");
        $("#denominacionDistEntrada").val("");
        $("#denominacionGenEntrada").val("");
        $("#presentacionEntrada").val("");
        $("#fechaEntrada").val("");
        $("#procedenciaEntrada").val("");
        $("#domicilioEntrada").val("");
        $("#numFacturaEntrada").val("");
        $("#cantidadEntrada").val("");
        $("#saldoEntrada").val("");
        $("#observacionesEntrada").val("");

        formActualizaEntrada.resetForm();
        $("#btn_actualiza_entrada").prop('disabled', false);
    }



    function modalModificaSalida(data) {
        $("#nombre_producto_salida").text(data.producto);

        $("#id_edit_salida").val(data.id);
        $("#denominacionDistSalida").val(data.denominacion_dist);
        $("#denominacionGenSalida").val(data.denominacion_gen);
        $("#presentacionSalida").val(data.presentacion);
        $("#fechaSalida").val(data.fecha);
        $("#preescribeSalida").val(data.nombre_pree);
        $("#domicilioSalida").val(data.domicilio);
        $("#cedulaSalida").val(data.cedula);
        $("#cantidadSalida").val(data.cantidad_vendida);
        $("#saldoSalida").val(data.saldo);
        $("#observacionesSalida").val(data.observaciones);

        toggleModal("modifica_registro_salida");
    }


    function limpiaFormSalida() {
        $("#nombre_producto_salida").text("");

        $("#id_edit_salida").val("");
        $("#denominacionDistSalida").val("");
        $("#denominacionGenSalida").val("");
        $("#presentacionSalida").val("");
        $("#fechaSalida").val("");;
        $("#preescribeSalida").val("");
        $("#domicilioSalida").val("");
        $("#cedulaSalida").val("");
        $("#cantidadSalida").val("");
        $("#saldoSalida").val("");
        $("#observacionesSalida").val("");

        formActualizaSalida.resetForm();
        $("#btn_actualiza_salida").prop('disabled', false);
    }

    $(document).on("click", ".btn-elimina-registro", function () {
        idDelete = $(this).data("id");
        movimientoDelete = $(this).data("movimiento");
        const sucursal = $('option:selected', '#sucursal_ajuste').data("nombre");

        $("#mensaje_confirma_delete").text("¿Deseas eliminar el registro " + idDelete + " de la sucursal " + sucursal + "?");
        toggleModal("notificacion_confirma_delete");
    });

    $(document).on("click", "#btn_confirma_delete", function () {
        const sucursal = $('option:selected', '#sucursal_ajuste').val();

        $.ajax({
            url: route('ajusteMovimientos.eliminaRegistro'),
            type: "POST",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
                id: idDelete,
                movimiento: movimientoDelete,
                sucursal: sucursal
            },
            beforeSend: function () {
                toggleModal("notificacion_confirma_delete");
            },
            success: function (data) {
                setTableData();
                $("#mensaje_success").text(data.mensaje);
                toggleModal("notificacion_success");

                idDelete = 0;
                movimientoDelete = "";
            },
            error: function (request, status, error) {
                $("#mensaje_error").text("UPS a ocurrido un error al momento de eliminar el registro del libro de antibiotico");
                toggleModal("notificacion_error");
            }
        });
    });

    $(document).on("click", ".btn-actualiza-registro", function () {
        const ID = $(this).data("id");
        const movimiento = $(this).data("movimiento");

        $.ajax({
            url: route('ajusteMovimientos.getDataMovimiento', [ID, sucursalFiltro]),
            contentType: false,
            processData: false,
            beforeSend: function () {
                if (movimiento === "ENTRADA") {
                    limpiaFormEntrada();
                } else if (movimiento === "SALIDA") {
                    limpiaFormSalida();
                }
            },
            success: function (data) {
                if (data.tipo_movimiento === "ENTRADA") {
                    modalModificaEntrada(data);
                } else if (data.tipo_movimiento === "SALIDA") {
                    modalModificaSalida(data);
                }
            }
        });
    });


    var formActualizaEntrada = $("#form_actualiza_entrada").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            denominacionDistEntrada: {
                required: true,
                maxlength: 50
            },
            denominacionGenEntrada: {
                required: true,
                maxlength: 50
            },
            presentacionEntrada: {
                required: true,
                maxlength: 50
            },
            procedenciaEntrada: {
                required: true,
                maxlength: 50
            },
            domicilioEntrada: {
                required: true,
                maxlength: 200
            },
            numFacturaEntrada: {
                required: true,
                maxlength: 50
            },
            cantidadEntrada: {
                required: true,
                digits: true,
                maxlength: 5
            },
            saldoEntrada: {
                required: true,
                digits: true,
                maxlength: 5
            },
            fechaEntrada: {
                required: true,
                date: true
            }
        },
        messages: {
            denominacionDistEntrada: {
                required: "El campo denominación distintiva es requerido",
                maxlength: "La denominación distintiva debe tener como máximo 50 caracteres"
            },
            denominacionGenEntrada: {
                required: "El campo denominación generica es requerido",
                maxlength: "La denominación generica debe tener como máximo 50 caracteres"
            },
            presentacionEntrada: {
                required: "El campo presentacion es requerido",
                maxlength: "La presentacion debe tener como máximo 50 caracteres"
            },
            procedenciaEntrada: {
                required: "El campo procedencia es requerido",
                maxlength: "La procedencia debe tener como máximo 50 caracteres"
            },
            domicilioEntrada: {
                required: "El campo domicilio es requerido",
                maxlength: "El domicilio debe tener como máximo 200 caracteres"
            },
            numFacturaEntrada: {
                required: "El campo Num. factura es requerido",
                maxlength: "El Num. factura debe tener como máximo 50 caracteres"
            },
            cantidadEntrada: {
                required: "El campo cantidad es requerido",
                number: "La cantidad solo puede contener digitos",
                maxlength: "La cantidad debe tener como máximo 5 digitos"
            },
            saldoEntrada: {
                required: "El campo saldo es requerido",
                number: "El saldo solo puede contener digitos",
                maxlength: "El saldo debe tener como máximo 5 digitos"
            },
            fechaEntrada: {
                required: "El campo fecha de registro es requerido",
                date: "La fecha de registro debe ser una fecha valida"
            }
        },
        submitHandler: function (form, e) {
            e.preventDefault();
            $("#btn_actualiza_entrada").prop('disabled', true);

            $.ajax({
                url: route('ajusteMovimientos.actulizaEntrada'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    denominacionDist: $("#denominacionDistEntrada").val(),
                    denominacionGen: $("#denominacionGenEntrada").val(),
                    presentacion: $("#presentacionEntrada").val(),
                    fecha: $("#fechaEntrada").val(),
                    procedencia: $("#procedenciaEntrada").val(),
                    domicilio: $("#domicilioEntrada").val(),
                    numFactura: $("#numFacturaEntrada").val(),
                    cantidad: $("#cantidadEntrada").val(),
                    saldo: $("#saldoEntrada").val(),
                    observaciones: $("#observacionesEntrada").val(),

                    sucursal: $('option:selected', '#sucursal_ajuste').val(),
                    id_edit: $("#id_edit").val()
                },
                success: function (data) {
                    setTableData();
                    $("#mensaje_success").text(data.mensaje);
                    toggleModal("notificacion_success");
                    toggleModal("modifica_registro_entrada");
                    limpiaFormEntrada();


                    //limpiaPantalla();
                },
                error: function (request, status, error) {
                    $("#mensaje_error").text("UPS a ocurrido un error al momento de actualizar el registro de entrada del libro de antibiotico");
                    toggleModal("notificacion_error");
                }

            });

        }
    });


    var formActualizaSalida = $("#form_actualiza_salida").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            denominacionDistSalida: {
                required: true,
                maxlength: 50
            },
            denominacionGenSalida: {
                required: true,
                maxlength: 50
            },
            presentacionSalida: {
                required: true,
                maxlength: 50
            },
            preescribeSalida: {
                required: true,
                maxlength: 50
            },
            domicilioSalida: {
                required: true,
                maxlength: 200
            },
            cedulaSalida: {
                required: true,
                maxlength: 50
            },
            cantidadSalida: {
                required: true,
                digits: true,
                maxlength: 5
            },
            saldoSalida: {
                required: true,
                digits: true,
                maxlength: 5
            },
            fechaSalida: {
                required: true,
                date: true
            }
        },
        messages: {
            denominacionDistSalida: {
                required: "El campo denominación distintiva es requerido",
                maxlength: "La denominación distintiva debe tener como máximo 50 caracteres"
            },
            denominacionGenSalida: {
                required: "El campo denominación generica es requerido",
                maxlength: "La denominación generica debe tener como máximo 50 caracteres"
            },
            presentacionSalida: {
                required: "El campo presentacion es requerido",
                maxlength: "La presentacion debe tener como máximo 50 caracteres"
            },
            preescribeSalida: {
                required: "El nombre de quien preescribe es requerido",
                maxlength: "El nombre de quien preescribe debe tener como máximo 50 caracteres"
            },
            domicilioSalida: {
                required: "El campo domicilio es requerido",
                maxlength: "El domicilio debe tener como máximo 200 caracteres"
            },
            cedulaSalida: {
                required: "El campo cedula profesional es requerido",
                maxlength: "La cedula profesional debe tener como máximo 50 caracteres"
            },
            cantidadSalida: {
                required: "El campo cantidad es requerido",
                number: "La cantidad solo puede contener digitos",
                maxlength: "La cantidad debe tener como máximo 5 digitos"
            },
            saldoSalida: {
                required: "El campo saldo es requerido",
                number: "El saldo solo puede contener digitos",
                maxlength: "El saldo debe tener como máximo 5 digitos"
            },
            fechaSalida: {
                required: "El campo fecha de registro es requerido",
                date: "La fecha de registro debe ser una fecha valida"
            }
        },
        submitHandler: function (form, e) {
            e.preventDefault();
            $("#btn_actualiza_salida").prop('disabled', true);

            $.ajax({
                url: route('ajusteMovimientos.actulizaSalida'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    denominacionDist: $("#denominacionDistSalida").val(),
                    denominacionGen: $("#denominacionGenSalida").val(),
                    presentacion: $("#presentacionSalida").val(),
                    preescribe: $("#preescribeSalida").val(),
                    domicilio: $("#domicilioSalida").val(),
                    cedula: $("#cedulaSalida").val(),
                    cantidad: $("#cantidadSalida").val(),
                    saldo: $("#saldoSalida").val(),
                    observaciones: $("#observacionesSalida").val(),

                    sucursal: $('option:selected', '#sucursal_ajuste').val(),
                    fecha: $("#fechaSalida").val(),
                    id_edit: $("#id_edit_salida").val()
                },
                success: function (data) {
                    setTableData();
                    $("#mensaje_success").text(data.mensaje);
                    toggleModal("notificacion_success");
                    toggleModal("modifica_registro_salida");
                    limpiaFormSalida();
                },
                error: function (request, status, error) {
                    $("#mensaje_error").text("UPS a ocurrido un error al momento de actualizar el registro de salida del libro de antibiotico");
                    toggleModal("notificacion_error");

                    $('#btn_inicia_salida').attr('disabled', true);
                }

            });
        }
    });


    $("#form_corrige_recete").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            sucursal_receta: {
                required: true,
            }
        },
        messages: {
            sucursal_receta: {
                required: "Selecciona una sucursal",
            }
        },
        submitHandler: function (form, e) {
            e.preventDefault();
            const formularioData = new FormData(form);

            $.ajax({
                url: route('ajusteMovimientos.corrigeNumReceta'),
                type: "POST",
                data: formularioData,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    toggleModal('sucursal_corrige_receta');
                    toggleModal('modal_cargando');
                },
                success: function (data) {
                    toggleModal('modal_cargando');

                    $("#mensaje_success").text(data.mensaje);
                    toggleModal("notificacion_success");
                },
                error: function (request) {
                    toggleModal('modal_cargando');

                    $("#mensaje_error").text("UPS a ocurrido un error al momento de corregir los numeros de receta");
                    toggleModal("notificacion_error");
                }

            });
        }
    });





    /**
     * If the modal is visible, hide it. If the modal is hidden, show it
     * @param  - The id of the modal you want to toggle.
     */
    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }



});
