$(document).ready(function () {
    //Solo permite ingresar numeros.
    $("#cantidadEntrada").numeric(false,
        function () {
            this.value = '0';
            this.focus();
        });

    $("#saldoEntrada").numeric(false,
        function () {
            this.value = '0';
            this.focus();
        });

    //Se realiza la suma de la cantidad de entrada y el saldo
    $("#cantidadEntrada").keyup(function () {
        let cantidad = parseInt($("#cantidadEntrada").val());
        const saldoOriginal = parseInt($("#saldoEntrada").data("saldoOriginal"));

        //Si no se ingresa ninguna cantidad se pone el saldo original
        if (Number.isNaN(cantidad)) {
            $("#saldoEntrada").val(saldoOriginal != 0 ? saldoOriginal : "")
        } else {
            if (cantidad > 0) {
                $("#saldoEntrada").val(parseInt(saldoOriginal + cantidad));
            } else {
                $("#cantidadEntrada").val("");
            }
        }
    });

    function validaFormInicioEntrada() {
        let errorSKU = $("#sku_entrada").val() == "" ? "Favor de ingresar el codigo del producto" : "";
        $("#sku_entrada-error").text(errorSKU)

        //Verificamos si el DIV de la lista de las sucursales existe
        if (document.getElementById('sucursal_entrada') != null) {
            let errorSucursal = $('option:selected', '#sucursal_entrada').val() == "" ? "Favor de seleccionar una sucursal" : "";
            $("#sucursal_entrada-error").text(errorSucursal)

            return (($('option:selected', '#sucursal_entrada').val() != "") && ($("#sku_entrada").val() != ""));
        } else {
            return (($("#sku_entrada").val() != ""));
        }
    }

    function limpiaPantalla() {
        $('#denominacionDistEntrada').val("");
        $('#denominacionGenEntrada').val("");
        $('#presentacionEntrada').val("");
        $('#laboratorioEntrada').val("");
        $('#saldoEntrada').val("");

        $('#procedenciaEntrada').val("");
        $('#domicilioEntrada').val("");
        $('#numFacturaEntrada').val("");
        $('#cantidadEntrada').val("");
        $('#observacionesEntrada').val("");

        $('#sku_entrada').val("");

        $('#nombre_producto').text("");
        $('#denominacionDistEntrada').attr('disabled', true);
        $('#denominacionGenEntrada').attr('disabled', true);
        $('#presentacionEntrada').attr('disabled', true);
        $('#saldoEntrada').attr('disabled', true);

        $('#procedenciaEntrada').attr('disabled', true);
        $('#domicilioEntrada').attr('disabled', true);
        $('#numFacturaEntrada').attr('disabled', true);
        $('#cantidadEntrada').attr('disabled', true);
        $('#observacionesEntrada').attr('disabled', true);

        $('#btn_registra_entrada').attr('disabled', true);
        $('#btn_limpia_entrada').attr('disabled', true);

        $('#btn_inicia_entrada').attr('disabled', false);
        $('#sku_entrada').attr('disabled', false);
        $('#sucursal_entrada').attr('disabled', false);



        $('#skuProductoEntrada').val("");
        $('#nameProductoEntrada').val("");
        $('#sucursalEntrada').val("");


        formRegistraEntrada.resetForm();

        $('#sku_entrada').focus();
        $('#sku_entrada').select();
    }

    $(document).on("click", "#btn_limpia_entrada", function () {
        limpiaPantalla();
    });

    $(document).on("click", "#btn_inicia_entrada", function () {

        if (validaFormInicioEntrada()) {
            const sucursal = document.getElementById('sucursal_entrada') != null ? $('option:selected', '#sucursal_entrada').val() : "";
            const SKU = $("#sku_entrada").val();

            $.ajax({
                url: route('registraMovimientos.getDatosProducto'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    codigo_producto: SKU,
                    sucursal: sucursal,
                },

                beforeSend: function () {
                    $('#denominacionDistEntrada').val("");
                    $('#denominacionGenEntrada').val("");
                    $('#presentacionEntrada').val("");
                    $('#laboratorioEntrada').val("");
                    $('#saldoEntrada').val("");
                },
                success: function (data) {

                    if (data.id === 0) {
                        $('#denominacionDistEntrada').attr('disabled', false);
                        $('#denominacionGenEntrada').attr('disabled', false);
                        $('#presentacionEntrada').attr('disabled', false);
                        $('#saldoEntrada').attr('disabled', false);
                    } else {
                        $('#denominacionDistEntrada').val(data.denominacion_dist);
                        $('#denominacionGenEntrada').val(data.denominacion_gen);
                        $('#presentacionEntrada').val(data.presentacion);
                        $('#saldoEntrada').val(data.saldo);
                    }

                    $('#nombre_producto').text(data.producto);

                    $('#laboratorioEntrada').val(data.laboratorio);
                    $("#saldoEntrada").data("saldoOriginal", data.saldo);

                    $('#procedenciaEntrada').attr('disabled', false);
                    $('#domicilioEntrada').attr('disabled', false);
                    $('#numFacturaEntrada').attr('disabled', false);
                    $('#cantidadEntrada').attr('disabled', false);
                    $('#observacionesEntrada').attr('disabled', false);

                    $('#btn_registra_entrada').attr('disabled', false);
                    $('#btn_limpia_entrada').attr('disabled', false);

                    $('#btn_inicia_entrada').attr('disabled', true);
                    $('#sku_entrada').attr('disabled', true);
                    $('#sucursal_entrada').attr('disabled', true);
                },
                error: function (request, status, error) {
                    let mensaje = request.responseJSON.error;

                    $("#mensaje_error").text(mensaje);
                    toggleModal("notificacion_error");
                }
            });
        }
    });



    var formRegistraEntrada = $("#form_registra_entrada").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            denominacionDistEntrada: {
                required: true,
                maxlength: 50
            },
            denominacionGenEntrada: {
                required: true,
                maxlength: 50
            },
            presentacionEntrada: {
                required: true,
                maxlength: 50
            },
            procedenciaEntrada: {
                required: true,
                maxlength: 50
            },
            domicilioEntrada: {
                required: true,
                maxlength: 200
            },
            numFacturaEntrada: {
                required: true,
                maxlength: 50
            },
            cantidadEntrada: {
                required: true,
                digits: true,
                maxlength: 5
            },
            saldoEntrada: {
                required: true,
                digits: true,
                maxlength: 5
            }
        },
        messages: {
            denominacionDistEntrada: {
                required: "El campo denominación distintiva es requerido",
                maxlength: "La denominación distintiva debe tener como máximo 50 caracteres"
            },
            denominacionGenEntrada: {
                required: "El campo denominación generica es requerido",
                maxlength: "La denominación generica debe tener como máximo 50 caracteres"
            },
            presentacionEntrada: {
                required: "El campo presentacion es requerido",
                maxlength: "La presentacion debe tener como máximo 50 caracteres"
            },
            procedenciaEntrada: {
                required: "El campo procedencia es requerido",
                maxlength: "La procedencia debe tener como máximo 50 caracteres"
            },
            domicilioEntrada: {
                required: "El campo domicilio es requerido",
                maxlength: "El domicilio debe tener como máximo 200 caracteres"
            },
            numFacturaEntrada: {
                required: "El campo Num. factura es requerido",
                maxlength: "El Num. factura debe tener como máximo 50 caracteres"
            },
            cantidadEntrada: {
                required: "El campo cantidad es requerido",
                number: "La cantidad solo puede contener digitos",
                maxlength: "La cantidad debe tener como máximo 5 digitos"
            },
            saldoEntrada: {
                required: "El campo saldo es requerido",
                number: "El saldo solo puede contener digitos",
                maxlength: "El saldo debe tener como máximo 5 digitos"
            }
        },
        submitHandler: function (form, e) {
            e.preventDefault();
            const sucursal = document.getElementById('sucursal_entrada') != null ? $('option:selected', '#sucursal_entrada').val() : "";

            $.ajax({
                url: route('registraMovimientos.registraEntrada'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    producto: $("#nombre_producto").text(),
                    codigoProducto: $("#sku_entrada").val(),
                    denominacionDist: $("#denominacionDistEntrada").val(),
                    denominacionGen: $("#denominacionGenEntrada").val(),
                    presentacion: $("#presentacionEntrada").val(),
                    laboratorio: $("#laboratorioEntrada").val(),
                    procedencia: $("#procedenciaEntrada").val(),
                    domicilio: $("#domicilioEntrada").val(),
                    numFactura: $("#numFacturaEntrada").val(),
                    cantidad: $("#cantidadEntrada").val(),
                    saldo: $("#saldoEntrada").val(),
                    observaciones: $("#observacionesEntrada").val(),
                    sucursal: sucursal
                },
                success: function (data) {
                    $("#mensaje_success").text(data.mensaje);
                    toggleModal("notificacion_success");

                    limpiaPantalla();
                },
                error: function (request, status, error) {
                    $("#mensaje_error").text("UPS a ocurrido un error al momento de registrar la entrada al libro de antibiotico");
                    toggleModal("notificacion_error");
                }

            });
        }
    });




    /**
     * If the modal is visible, hide it. If the modal is hidden, show it
     * @param  - The id of the modal you want to toggle.
     */
    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
