$(document).ready(function () {
    //Solo permite ingresar numeros.
    $("#cantidadSalida").numeric(false,
        function () {
            this.value = '0';
            this.focus();
        });

    $("#saldoSalida").numeric(false,
        function () {
            this.value = '0';
            this.focus();
        });




    $("#cantidadSalida").keyup(function () {
        let cantidad = parseInt($("#cantidadSalida").val());
        const saldoOriginal = parseInt($("#saldoSalida").data("saldoOriginal"));

        //Si no se ingresa ninguna cantidad se pone el saldo original
        if (Number.isNaN(cantidad)) {
            $("#saldoSalida").val(saldoOriginal != 0 ? saldoOriginal : 0)

        } else {
            if (saldoOriginal != 0 && cantidad > 0 && cantidad <= saldoOriginal) {
                $("#saldoSalida").val(parseInt(saldoOriginal - cantidad));
            } else {
                $("#cantidadSalida").val("");
                $("#saldoSalida").val(parseInt(saldoOriginal) || 0);
            }
        }
    });

    function validaFormInicioSalida() {
        let errorSKU = $("#sku_salida").val() == "" ? "Favor de ingresar el codigo del producto" : "";
        $("#sku_salida-error").text(errorSKU)

        //Verificamos si el DIV de la lista de las sucursales existe
        if (document.getElementById('sucursal_salida') != null) {
            let errorSucursal = $('option:selected', '#sucursal_salida').val() == "" ? "Favor de seleccionar una sucursal" : "";
            $("#sucursal_salida-error").text(errorSucursal)

            return (($('option:selected', '#sucursal_salida').val() != "") && ($("#sku_salida").val() != ""));
        } else {
            return (($("#sku_salida").val() != ""));
        }
    }

    function limpiaPantalla() {
        $('#denominacionDistSalida').val("");
        $('#denominacionGenSalida').val("");
        $('#presentacionSalida').val("");
        $('#laboratorioSalida').val("");
        $('#saldoSalida').val("");

        $('#preescribeSalida').val("");
        $('#domicilioSalida').val("");
        $('#cedulaSalida').val("");
        $('#cantidadSalida').val("");
        $('#observacionesSalida').val("");

        $('#sku_salida').val("");

        $('#nombre_producto_salida').text("");
        $('#denominacionDistSalida').attr('disabled', true);
        $('#denominacionGenSalida').attr('disabled', true);
        $('#presentacionSalida').attr('disabled', true);
        $('#saldoSalida').attr('disabled', true);

        $('#preescribeSalida').attr('disabled', true);
        $('#domicilioSalida').attr('disabled', true);
        $('#cedulaSalida').attr('disabled', true);
        $('#listaSurtidos').attr('disabled', true);
        $('#cantidadSalida').attr('disabled', true);
        $('#observacionesSalida').attr('disabled', true);

        $('#btn_registra_salida').attr('disabled', true);
        $('#btn_limpia_salida').attr('disabled', true);

        $('#btn_inicia_salida').attr('disabled', false);
        $('#sku_salida').attr('disabled', false);
        $('#sucursal_salida').attr('disabled', false);



        $('#skuProductoEntrada').val("");
        $('#nameProductoEntrada').val("");
        $('#sucursalEntrada').val("");


        formRegistraSalida.resetForm();

        $('#sku_salida').focus();
        $('#sku_salida').select();
    }

    $(document).on("click", "#btn_limpia_salida", function () {
        limpiaPantalla();
    });

    $(document).on("click", "#btn_inicia_salida", function () {

        if (validaFormInicioSalida()) {
            const sucursal = document.getElementById('sucursal_salida') != null ? $('option:selected', '#sucursal_salida').val() : "";
            const SKU = $("#sku_salida").val();

            $.ajax({
                url: route('registraMovimientos.getDatosProducto'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    codigo_producto: SKU,
                    sucursal: sucursal,
                },

                beforeSend: function () {
                    $('#denominacionDistSalida').val("");
                    $('#denominacionGenSalida').val("");
                    $('#presentacionSalida').val("");
                    $('#laboratorioSalida').val("");
                    $('#saldoSalida').val("");
                },
                success: function (data) {

                    if (data.id === 0) {
                        $('#denominacionDistSalida').attr('disabled', false);
                        $('#denominacionGenSalida').attr('disabled', false);
                        $('#presentacionSalida').attr('disabled', false);
                        $('#saldoSalida').attr('disabled', false);
                    } else {
                        $('#denominacionDistSalida').val(data.denominacion_dist);
                        $('#denominacionGenSalida').val(data.denominacion_gen);
                        $('#presentacionSalida').val(data.presentacion);
                        $('#saldoSalida').val(data.saldo);
                    }

                    $('#nombre_producto_salida').text(data.producto);

                    $('#laboratorioSalida').val(data.laboratorio);
                    $("#saldoSalida").data("saldoOriginal", data.saldo);



                    $('#preescribeSalida').attr('disabled', false);
                    $('#domicilioSalida').attr('disabled', false);
                    $('#cedulaSalida').attr('disabled', false);

                    $('#listaSurtidos').attr('disabled', false);

                    $('#cantidadSalida').attr('disabled', false);
                    $('#observacionesSalida').attr('disabled', false);

                    $('#btn_registra_salida').attr('disabled', false);
                    $('#btn_limpia_salida').attr('disabled', false);

                    $('#btn_inicia_salida').attr('disabled', true);
                    $('#sku_salida').attr('disabled', true);
                    $('#sucursal_salida').attr('disabled', true);
                },
                error: function (request, status, error) {
                    let mensaje = request.responseJSON.error;

                    $("#mensaje_error").text(mensaje);
                    toggleModal("notificacion_error");
                }
            });
        }
    });



    var formRegistraSalida = $("#form_registra_salida").validate({
        debug: false,
        event: "blur",
        errorElement: "label",

        rules: {
            denominacionDistSalida: {
                required: true,
                maxlength: 50
            },
            denominacionGenSalida: {
                required: true,
                maxlength: 50
            },
            presentacionSalida: {
                required: true,
                maxlength: 50
            },
            preescribeSalida: {
                required: true,
                maxlength: 50
            },
            domicilioSalida: {
                required: true,
                maxlength: 200
            },
            cedulaSalida: {
                required: true,
                maxlength: 50
            },
            cantidadSalida: {
                required: true,
                digits: true,
                maxlength: 5
            },
            saldoSalida: {
                required: true,
                digits: true,
                maxlength: 5
            },
            listaSurtidos: {
                required: true
            }
        },
        messages: {
            denominacionDistSalida: {
                required: "El campo denominación distintiva es requerido",
                maxlength: "La denominación distintiva debe tener como máximo 50 caracteres"
            },
            denominacionGenSalida: {
                required: "El campo denominación generica es requerido",
                maxlength: "La denominación generica debe tener como máximo 50 caracteres"
            },
            presentacionSalida: {
                required: "El campo presentacion es requerido",
                maxlength: "La presentacion debe tener como máximo 50 caracteres"
            },
            preescribeSalida: {
                required: "El nombre de quien preescribe es requerido",
                maxlength: "El nombre de quien preescribe debe tener como máximo 50 caracteres"
            },
            domicilioSalida: {
                required: "El campo domicilio es requerido",
                maxlength: "El domicilio debe tener como máximo 200 caracteres"
            },
            cedulaSalida: {
                required: "El campo cedula profesional es requerido",
                maxlength: "La cedula profesional debe tener como máximo 50 caracteres"
            },
            cantidadSalida: {
                required: "El campo cantidad es requerido",
                number: "La cantidad solo puede contener digitos",
                maxlength: "La cantidad debe tener como máximo 5 digitos"
            },
            saldoSalida: {
                required: "El campo saldo es requerido",
                number: "El saldo solo puede contener digitos",
                maxlength: "El saldo debe tener como máximo 5 digitos"
            },

            listaSurtidos: {
                required: "Favor de seleccionar una opción"
            }
        },
        submitHandler: function (form, e) {
            e.preventDefault();
            const sucursal = document.getElementById('sucursal_salida') != null ? $('option:selected', '#sucursal_salida').val() : "";

            $.ajax({
                url: route('registraMovimientos.registraSalida'),
                type: "POST",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    producto: $("#nombre_producto_salida").text(),
                    codigoProducto: $("#sku_salida").val(),
                    denominacionDist: $("#denominacionDistSalida").val(),
                    denominacionGen: $("#denominacionGenSalida").val(),
                    presentacion: $("#presentacionSalida").val(),
                    laboratorio: $("#laboratorioSalida").val(),
                    preescribe: $("#preescribeSalida").val(),
                    domicilio: $("#domicilioSalida").val(),
                    cedula: $("#cedulaSalida").val(),
                    surtido: $('option:selected', '#listaSurtidos').val(),
                    cantidad: $("#cantidadSalida").val(),
                    saldo: $("#saldoSalida").val(),
                    observaciones: $("#observacionesSalida").val(),
                    sucursal: sucursal
                },
                beforeSend: function(){
                    $('#btn_inicia_salida').attr('disabled', false);
                },
                success: function (data) {
                    $("#mensaje_success").text(data.mensaje);
                    toggleModal("notificacion_success");

                    limpiaPantalla();
                },
                error: function (request, status, error) {
                    $("#mensaje_error").text("UPS a ocurrido un error al momento de registrar la saida del libro de antibiotico");
                    toggleModal("notificacion_error");

                    $('#btn_inicia_salida').attr('disabled', true);
                }

            });
        }
    });




    /**
     * If the modal is visible, hide it. If the modal is hidden, show it
     * @param  - The id of the modal you want to toggle.
     */
    function toggleModal($modal) {
        var body = document.querySelector('body');
        var modal = document.querySelector('#' + $modal);
        modal.classList.toggle('opacity-0');
        modal.classList.toggle('pointer-events-none');
        body.classList.toggle('modal-active');
    }
});
