@extends('layouts.app')
@section('title', 'Inicio sesión')

@section('content')

    <div class="bg-white">
        <div class="flex justify-center h-screen">
            <div class="flex items-center w-full max-w-md px-6 mx-auto lg:w-2/6">
                <div class="flex-1">
                    <div class="text-center grid auto-rows-auto justify-items-center grid-flow-row">
                        <img class="w-48" src="{{ asset('images/auth/logo.png') }}">

                        <p class="mt-3 text-gray-500">Inicie sesión para acceder a su cuenta</p>
                    </div>

                    <div class="mt-8">
                        <form method="POST" action="{{ route('login') }}">
                            @csrf

                            <div>
                                <label for="username"
                                    class="block mb-2 text-base font-semibold text-gray-600">Usuario</label>
                                <input required type="text" name="username" id="email"
                                    placeholder="Usuario"
                                    class="input-login" />
                            </div>

                            <div class="mt-6">
                                <div class="flex justify-between mb-2">
                                    <label for="password"
                                        class="text-base font-semibold text-gray-600">Contraseña</label>
                                </div>

                                <input required autocomplete="current-password" type="password" name="password"
                                    id="password" placeholder="Contraseña"
                                    class="input-login" />
                            </div>
                            <br>

                            @error('message')
                                <div class="p-4 mb-4 text-sm text-text-error bg-background-error rounded-lg" role="alert">
                                    <strong>{{ $message }}</strong>
                                </div>
                            @enderror

                            <div class="mt-6">
                                <button type="submit"
                                    class="btn-primary-login">
                                    Iniciar sesión
                                </button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
            <div class="hidden bg-cover lg:block lg:w-2/3"
                style="background-image: url('{{ asset('images/auth/fondo1.jpg') }}');"></div>
            </div>
    </div>
@endsection
