@extends('layouts.app')
@section('title', 'Inicio sesión')

@section('content')

    <div class="container min-h-[35px] min-w-full bg-header-login"></div>

    <div class="container h-[96.3vh] min-w-full pt-40 pl-32"
        style="background-image: url('{{ asset('images/auth/fondo.png') }}'); background-size: cover; background-repeat: no-repeat; background-position: center;">

        <div class="w-fit h-fit rounded-lg overflow-hidden shadow-lg bg-white border border-border-card-corte">
            <div class="w-fit mx-9 my-10 flex flex-col items-center">
                <img class="w-96" src="{{ asset('images/auth/logo.png') }}">

                <div class="mt-24">
                    <form method="POST" action="{{ route('login') }}" class=" grid grid-rows-4 gap-5">
                        @csrf

                        <div class="grid grid-flow-col auto-cols-max gap-x-8 items-center">
                            <label class="text-xl font-semibold col-end-1" for="username">Usuario: </label>
                            <div>
                                <input type="text" name="username" id="email"
                                    class="border-2 border-border-input p-1.5 text-base rounded-lg row-end-2 shadow-lg"
                                    required>
                            </div>
                        </div>

                        <div class="grid grid-flow-col auto-cols-max gap-x-3 items-center">
                            <label class="text-xl font-semibold" for="password">Password:</label>

                            <div>
                                <input type="password" id="password" name="password"
                                    class="border-2 border-border-input p-1.5 text-base rounded-lg row-end-2 shadow-lg"
                                    required autocomplete="current-password">
                            </div>
                        </div>
                        <br>

                        @error('message')
                            <div class="p-4 mb-4 text-sm text-text-error bg-background-error rounded-lg" role="alert">
                                <strong>{{ $message }}</strong>
                            </div>
                        @enderror

                        <div class="text-center text-base">
                            <button type="submit"
                                class="bg-boton-login hover:bg-boton-login-hover text-white font-bold py-2 px-4 rounded-lg shadow-lg">
                                Iniciar sesión
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endsection
