@extends('layouts.dashboard.dashboard')
@section('title', 'Cajones')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Configuraciones</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Catalogos</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Cajones</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <!-- Content -->
            <div class="div-header-dashboard">
                <div class="div-title-dashboard title-dashboard">
                    <a>Cajones</a>
                </div>

                <div class="div-buttons-header-corte">
                    @if ($mensaje == '')    
                        <button type="button" data-modal="registra-cajones" class="modal-open btn-primary-fit">
                            Agregar Cajones
                        </button>                        
                    @elseif($mensaje == 'Completo')
                        <label class="label-form aviso pt-4">Ya se cuenta con la cantidad máxima de cajones registrados</label>
                    @endif
                </div>
            </div>

            <div class="div-header-buttons-corte-resp">

                <div class="div-buttons-header-corte-resp">
                    @if ($mensaje == '')    
                    <button type="button" data-modal="registra-cajones" class="modal-open btn-primary-fit">
                        Agregar Cajones
                    </button>                        
                    @elseif($mensaje == 'Completo')
                        <label class="label-form aviso pt-4">Ya se cuenta con la cantidad máxima de cajones registrados</label>
                    @endif
                </div>
            </div>

            <div class="material-datatables mt-8">
                <table id="cajones-table" class="stripe" cellspacing="0" width="100%" style="width:100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Numero</th>
                            <th>Nomeclatura</th>
                            <th>Ocupado</th>

                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        @include('layouts.dashboard.partials.configuraciones.cajones.modals')
    @endsection
    @section('scripts')
        <script src="{{ asset('js/configuraciones/catalogos/cajones.js') }}" defer></script>
    @endsection