@extends('layouts.dashboard.dashboard')
@section('title', 'Códigos Postales')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Configuraciones</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Catalogos</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Códigos Postales</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <!-- Content -->
            <div class="div-header-dashboard">
                <div class="div-title-dashboard title-dashboard">
                    <a>Códigos Postales</a>
                </div>

                <div class="div-buttons-header-corte">
                    <form class="" method="POST" id="gen_table">
                        @csrf
                        <div class="grid grid-cols-3 gap-3">   
                            <div for="bus_estado">
                                <label for="bus_estado" class="label-form">Estado</label>
                                <select id="bus_estado" name="bus_estado" required class="select-form-2 personhi" onchange="bus_muni();">
                                    <option value="">Seleccione un estado</option>
                                    @foreach ($estados as $estado)
                                        <option value="{{ $estado->estado }}">{{ $estado->estado }}
                                    @endforeach
                                </select>
                            </div>
                            <div for="bus_municipio">
                                <label for="bus_municipio" class="label-form">Municipio</label>
                                <select id="bus_municipio" name="bus_municipio" required class="select-form-2 personhi">
                                    <option value="0">Todos</option>
                                </select>
                            </div>
                            <div for="boton">
                                <button type="submit" id="busc_succes" class="btn-action-fit-modal mt-8">Buscar</button>

                                <button type="button" data-modal="registra-cp" class="modal-open btn-primary-fit-modal" onclick="bus_muni_3();">
                                    Agregar Código Postal
                                </button>
                            </div>
                        </div>
                    </form>
                   
                </div>
            </div>

            <div class="material-datatables mt-8">
                <table id="cp-table" class="stripe" cellspacing="0" width="100%" style="width:100%">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>CP.</th>
                            <th>Tipo de Asentamiento</th>
                            <th>Estado</th>
                            <th>Municipio</th>
                            <th>Ciudad</th>
                            <th>Colonia</th>
                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        @include('layouts.dashboard.partials.configuraciones.codigos_postales.modals')
    @endsection


    @section('scripts')
        <script src="{{ asset('js/configuraciones/catalogos/codigos_postales.js') }}" defer></script>
    @endsection