@extends('layouts.dashboard.dashboard')
@section('title', 'Permisos')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">
            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Configuraciones</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Permisos</span>
                    </li>
                </ol>
            </nav>
            <!-- //Pager Hedaer -->

            <!-- header -->
            <div class="div-header-dashboard">
                <div class="div-title-dashboard title-dashboard">
                    <a>Permisos</a>
                </div>

                <div class="div-buttons-header-corte">
                    @can('configuraciones.permisos.registra_permiso')
                        <button type="button" data-modal="registra-permiso" class="modal-open btn-primary-fit">
                            Agregar Permiso
                        </button>
                    @endcan

                    @can('configuraciones.permisos.categorias')
                        <a href="{{ route('configuraciones.permisos.categorias') }}" class="btn-primary-fit">
                            Categorias
                        </a>
                    @endcan

                    @can('configuraciones.permisos.subcategorias')
                        <a href="{{ route('configuraciones.permisos.subcategorias') }}" class="btn-primary-fit">
                            Subcategorias
                        </a>
                    @endcan
                </div>
            </div>

            <div class="div-header-buttons-corte-resp">
                <div class="div-buttons-header-corte-resp">
                    @can('configuraciones.permisos.registra_permiso')
                        <button type="button" data-modal="registra-permiso" class="modal-open btn-primary-full">
                            Agregar Permiso
                        </button>
                    @endcan

                    @can('configuraciones.permisos.categorias')
                        <a href="{{ route('configuraciones.permisos.categorias') }}" class="btn-primary-full">
                            Categorias
                        </a>
                    @endcan

                    @can('configuraciones.permisos.subcategorias')
                        <a href="{{ route('configuraciones.permisos.subcategorias') }}" class="btn-primary-full">
                            Subcategorias
                        </a>
                    @endcan
                </div>
            </div>
            <!-- //header -->

             <!-- Content -->
            <div class="material-datatables mt-8">
                <table id="permisos-table" class="stripe" cellspacing="0" width="100%" style="width:100%">
                    <thead>
                        <tr>
                            <th>Descripcion</th>
                            <th>Nombre</th>
                            <th>Categoria</th>
                            <th>Subcategoria</th>
                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
            <!-- Content -->

            @include('layouts.dashboard.partials.permisos.modals')
        </div>
    @endsection


    @section('scripts')
        <script src="{{ asset('js/configuraciones/permisos/permisos.js') }}" defer></script>
    @endsection
