@extends('layouts.dashboard.dashboard')
@section('title', 'Subcategorias Permisos')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">
            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs phone:hidden">Configuraciones</span>
                        <span class="a-beadcrumbs hidden phone:block">Conf.</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <a href="{{ route('configuraciones.permisos') }}" class="a-beadcrumbs-hover">Permisos</a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">SubCategorias</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <!-- header -->
            <div class="div-header-dashboard">
                <div class="div-title-dashboard title-dashboard">
                    <a>SubCategorias</a>
                </div>

                <div class="div-buttons-header-corte">
                    @can('configuraciones.permisos.subcategorias.registra_subcategoria')
                        <button type="button" data-modal="registra-subcategoria" class="modal-open btn-primary-fit">
                            Agregar SubCategoria
                        </button>
                    @endcan
                </div>
            </div>

            <div class="div-header-buttons-corte-resp">
                <div class="div-buttons-header-corte-resp">
                    @can('configuraciones.permisos.subcategorias.registra_subcategoria')
                        <button type="button" data-modal="registra-subcategoria" class="modal-open btn-primary-full">
                            Agregar SubCategoria
                        </button>
                    @endcan
                </div>
            </div>
            <!-- //header -->

            <div class="material-datatables mt-8">
                <table id="permisos-subcategorias-table" class="stripe" cellspacing="0" width="100%" style="width:100%">
                    <thead>
                        <tr>
                            <th class="w-3">#</th>
                            <th>Categoria</th>
                            <th>SubCategoria</th>
                            <th>Activa</th>
                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    @include('layouts.dashboard.partials.permisos.subcategorias.modals')
@endsection


@section('scripts')
    <script src="{{ asset('js/configuraciones/permisos/subcategorias.js') }}" defer></script>
@endsection
