@extends('layouts.dashboard.dashboard')
@section('title', 'Roles')

@section('content')
    <div class="container-dashboard">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">
                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Configuraciones</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Roles</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <!-- Content -->
            <!-- header -->
            <div class="div-header-dashboard">
                <div class="div-title-dashboard title-dashboard">
                    <a>Roles</a>
                </div>

                <div class="div-buttons-header-corte">
                    @can('configuraciones.roles.registra_rol')
                        <button type="button" data-modal="registra-rol" class="modal-open btn-primary-fit">
                            Agregar Rol
                        </button>
                    @endcan
                </div>
            </div>

            <div class="div-header-buttons-corte-resp">
                <div class="div-buttons-header-corte-resp">
                    @can('configuraciones.roles.registra_rol')
                        <button type="button" data-modal="registra-rol" class="modal-open btn-primary-full">
                            Agregar Rol
                        </button>
                    @endcan
                </div>
            </div>
            <!-- //header -->

            <div class="material-datatables mt-8">
                <table id="roles-table" class="stripe" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th class="w-3">#</th>
                            <th>Rol</th>

                            <th class="disabled-sorting">Acciones</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        @include('layouts.dashboard.partials.roles.modals')
    @endsection


    @section('scripts')
        <script src="{{ asset('js/configuraciones/roles.js') }}" defer></script>
    @endsection
