@extends('layouts.dashboard.dashboard')
@section('title', 'Ajuste de movimientos')

@section('content')
    <div class="container-dashboard max-w-[95%]">
        <!-- Pager Hedaer -->
        <div class="div-content-dashboard">

            <!-- breadcrumbs -->
            <nav class="flex py-3 text-gray-700" aria-label="Breadcrumb">
                <ol class="inline-flex items-center">

                    <li class="li-beadcrumbs">
                        <a href="{{ route('dashboard.inicio') }}" class="a-beadcrumbs-hover">
                            <i class="fa-solid fa-house mr-1 w-4 h-4"></i>
                            Inicio
                        </a>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs">Movimientos</span>
                    </li>
                    <li class="li-beadcrumbs">
                        <i class="fa-solid fa-chevron-right i-beadcrumbs"></i>
                        <span class="a-beadcrumbs font-semibold">Ajuste de movimientos</span>
                    </li>
                </ol>
            </nav>
            <!-- //breadcrumbs -->

            <div class="title-dashboard">
                <a>Ajuste de movimientos</a>
            </div>
            <!-- //Pager Hedaer -->

            <form method="POST" id="form_inicia_busqueda">
                <div class="div-header-corte px-5 py-5">
                    <div class="flex flex-row items-stretch gap-4">
                        @csrf

                        <div for="fecha_inicio" id='div_fecha_inicio' class='w-[22%]'>
                            <label class="label-form">Fecha inicio</label>
                            <input type="date" name="fecha_inicio" id="fecha_inicio" class="input-form" required>
                            <label id="fecha_inicio-error" class="error" for="fecha_inicio"></label>
                        </div>

                        <div for="fecha_fin" id='div_fecha_fin' class='w-[22%]'>
                            <label class="label-form">Fecha final</label>
                            <input type="date" name="fecha_fin" id="fecha_fin" class="input-form" required>
                            <label id="fecha_fin-error" class="error" for="fecha_fin"></label>
                        </div>

                        <div for="sucursal_ajuste" id='div_sucursal_ajuste' class="w-[25%]">
                            <label class="label-form">Sucursal</label>
                            <select id="sucursal_ajuste" name="sucursal_ajuste" class="select-form" required>
                                @foreach ($listaSucursales as $sucursal)
                                    <option value="{{ $sucursal->sucursal }}" data-nombre="{{ $sucursal->nombre }}">
                                        {{ $sucursal->nombre }}
                                    </option>
                                @endforeach
                            </select>
                            <label id="sucursal_ajuste-error" class="error" for="sucursal_ajuste"></label>
                        </div>

                        <div class="grid auto-cols-auto grid-flow-col justify-items-end self-end gap-x-3">
                            <button type="button" id='btn_busca_movimientos' class="btn-primary-fit">
                                Buscar
                            </button>

                            <button type="button" id="btn_limpia_busca_movimientos" disabled
                                class="btn-primary-fit">
                                Limpiar
                            </button>

                            <button type="button" id='btn_num_receta' class="modal-open btn-primary-fit" data-modal="sucursal_corrige_receta">
                                Corregir numeros de receta
                            </button>
                        </div>

                    </div>
                </div>
            </form>

            <div id="form_entrada" class="div-header-corte px-5 py-5">
                <div class="material-datatables mt-8 text-[13px]">
                    <table id="tabla_registros" class="stripe" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Movimiento</th>
                                <th>Fecha</th>
                                <th>Codigo</th>
                                <th>Producto</th>
                                <th>Denominacion distintiva</th>
                                <th>Denominacion generica</th>
                                <th>Presentacion</th>
                                <th>Num. Factura</th>
                                <th>Receta</th>
                                <th>Cant. adquirida</th>
                                <th>Cant. vendida</th>
                                <th>Saldo</th>

                                <th>Acciones</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>


            <!-- Content -->
        </div>
    </div>

    @include('layouts.dashboard.partials.movimientos.ajustes.modals')
@endsection


@section('scripts')
    <script src="{{ asset('js/movimientos/ajustes.js') }}" defer></script>
@endsection
