 <!--Modal registra permiso-->
 @can('configuraciones.permisos.registra_permiso')
     <div id="registra-permiso" tabindex="-1" aria-hidden="true" data-modal="registra-permiso"
         class="modal pointer-events-none opacity-0">
         <div class="backgroud-modal"></div>
         <div class="content-modal-33">

             <div class="modal-content py-4 text-left px-6">
                 <!--Title-->
                 <div class="flex justify-between items-center pb-3 mb-6">
                     <p class="text-2xl font-bold">Agregar permiso</p>
                     <div class="modal-close cursor-pointer z-50" data-modal="registra-permiso">
                         <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18"
                             height="18" viewBox="0 0 18 18">
                             <path
                                 d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z">
                             </path>
                         </svg>
                     </div>
                 </div>

                 <!--Body-->
                 <form class="space-y-6" method="POST" id="form_agrega_permiso"
                     action="{{ route('configuraciones.permisos.registra_permiso') }}">
                     @csrf

                     <div>
                         <label for="nombre_permiso" class="label-form">Permiso</label>
                         <input type="text" name="nombre_permiso" id="nombre_permiso" class="input-form"
                             placeholder="configuraciones.roles.elimina_rol" required>
                     </div>

                     <div>
                         <label for="descripcion_permiso" class="label-form">Descripcion</label>
                         <input type="text" name="descripcion_permiso" id="descripcion_permiso" class="input-form"
                             placeholder="Visualizar la opcion Permisos en el menu" required>
                     </div>

                     <div class="grid grid-cols-2 gap-4">
                         <div for="categoria">
                             <label for="categoria" class="label-form">Categoria</label>

                             <select id="categoria" name="categoria" required class="select-form">
                                 <option value="">SELECCIONE UNA CATEGORIA</option>
                                 @foreach ($categorias as $categoria)
                                     <option value="{{ $categoria->id }}">{{ $categoria->categoria }}</option>
                                 @endforeach
                             </select>
                         </div>

                         <div for="subCategoria">
                             <label for="subCategoria" class="label-form">SubCategoria</label>

                             <select id="subCategoria" name="subCategoria" required class="select-form">
                                 <option value="">SELECCIONE UNA SUBCATEGORIA</option>

                             </select>
                         </div>
                     </div>
             </div>

             <!--Footer-->
             <div class="footer-modal">
                 <a href="#" data-modal="registra-permiso" class="modal-close btn-cancel-fit-modal">Cerrar</a>
                 <button type="submit" id="btn-agregar-permiso" class="btn-primary-fit-modal">Agregar</button>
             </div>
             </form>
         </div>
     </div>
 @endcan
 <!-- //Modal registra permiso-->

 <!--Modal actualiza permiso-->
 @can('configuraciones.permisos.actuliza_permiso')
     <div id="actualiza-permiso" tabindex="-1" aria-hidden="true" data-modal="actualiza-permiso"
         class="modal pointer-events-none opacity-0">
         <div class="backgroud-modal"></div>
         <div class="content-modal-33">

             <div class="modal-content py-4 text-left px-6">
                 <!--Title-->
                 <div class="flex justify-between items-center pb-3 mb-6">
                     <p class="text-2xl font-bold">Editar permiso</p>
                     <div class="modal-close cursor-pointer z-50" data-modal="actualiza-permiso">
                         <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18"
                             height="18" viewBox="0 0 18 18">
                             <path
                                 d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z">
                             </path>
                         </svg>
                     </div>
                 </div>

                 <!--Body-->
                 <form class="space-y-6" method="POST" id="form_actualizar_permiso"
                     action="{{ route('configuraciones.permisos.actuliza_permiso') }}">
                     @csrf

                     <div>
                         <label for="nombre_permiso_edit" class="label-form">Permiso</label>
                         <input type="text" name="nombre_permiso_edit" id="nombre_permiso_edit" class="input-form"
                             required>
                     </div>

                     <div>
                         <label for="descripcion_permiso_edit" class="label-form">Descripcion</label>
                         <input type="text" name="descripcion_permiso_edit" id="descripcion_permiso_edit"
                             class="input-form" required>
                     </div>

                     <div class="grid grid-cols-2 gap-4">
                         <div for="categoria_edit">
                             <label for="categoria_edit" class="label-form">Categoria</label>

                             <select id="categoria_edit" name="categoria_edit" required class="select-form">
                                 <option value="">SELECCIONE UNA CATEGORIA</option>
                                 @foreach ($categorias as $categoria)
                                     <option value="{{ $categoria->id }}">{{ $categoria->categoria }}</option>
                                 @endforeach
                             </select>
                         </div>

                         <div for="subCategoria_edit">
                             <label for="subCategoria_edit" class="label-form">SubCategoria</label>

                             <select id="subCategoria_edit" name="subCategoria_edit" required class="select-form">
                                 <option value="">SELECCIONE UNA SUBCATEGORIA</option>

                             </select>
                         </div>
                     </div>
                     <input type="text" name="id_permiso_edit" id="id_permiso_edit" hidden>
             </div>

             <!--Footer-->
             <div class="footer-modal">
                 <a href="#" data-modal="actualiza-permiso" class="modal-close btn-cancel-fit-modal">Cerrar</a>
                 <button type="submit" id="btn-actualiza-permiso" class="btn-primary-fit-modal">Actualizar</button>
             </div>
             </form>
         </div>
     </div>
 @endcan
 <!-- //Modal actualiza permiso-->

 <!--Modal confirma eliminacion permiso-->
 @can('configuraciones.permisos.elimina_permiso')
     <div id="confirma-elimina-permiso" tabindex="-1" aria-hidden="true" data-modal="confirma-elimina-permiso"
         class="modal pointer-events-none opacity-0">
         <div class="backgroud-modal"></div>
         <div class="content-modal-25">

             <div class="modal-content py-4 text-left px-6">
                 <p id="mensaje-notificacion" class=" text-2xl font-bold text-center"></p>
             </div>

             <form method="POST" id="form_elimina_permiso"
                 action="{{ route('configuraciones.permisos.elimina_permiso') }}">
                 @csrf

                 <div class="footer-modal modal-content">
                     <input type="text" name="id_permiso_destroy" id="id_permiso_destroy" hidden>

                     <a href="#" data-modal="confirma-elimina-permiso"
                         class="modal-close btn-cancel-fit-modal">Cerrar</a>

                     <button type="submit" id="btn-eliminar-permiso" class="btn-primary-fit-modal">Aceptar</button>
                 </div>
             </form>
         </div>
     </div>
 @endcan
<!--//Modal confirma eliminacion permiso-->
