 <!--Modal registra rol-->
 @can('configuraciones.roles.registra_rol')
     <div id="registra-rol" tabindex="-1" aria-hidden="true" data-modal="registra-rol"
         class="modal pointer-events-none opacity-0">
         <div class="backgroud-modal"></div>
         <div class="content-modal-50">

             <div class="modal-content py-4 text-left px-6">
                 <!--Title-->
                 <div class="flex justify-between items-center pb-3 mb-6">
                     <p class="text-2xl font-bold">Agregar rol</p>
                     <div class="modal-close cursor-pointer z-50" data-modal="registra-rol">
                         <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18"
                             height="18" viewBox="0 0 18 18">
                             <path
                                 d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z">
                             </path>
                         </svg>
                     </div>
                 </div>

                 <!--Body-->
                 <form class="space-y-6" method="POST" id="form_agrega_rol"
                     action="{{ route('configuraciones.roles.registra_rol') }}">
                     @csrf

                     <div>
                         <label for="nombre_rol" class="label-form">Rol</label>
                         <input type="text" name="nombre_rol" id="nombre_rol" class="input-form"
                             placeholder="ADMINISTRADOR" required>
                     </div>

                     <h3 class="label-form">Permisos</h3>
                     <label id="permisos[]-error" class="error" for="permisos[]"></label>

                     <div id="div-permisos" class="overflow-y-auto h-[450px] pr-5" >
                         <!-- Se genera la lista de permisos mediante ajax-->
                     </div>


             </div>

             <!--Footer-->
             <div class="footer-modal">
                 <a href="#" data-modal="registra-rol" class="modal-close btn-cancel-fit-modal">Cerrar</a>
                 <button type="submit" id="btn-agrega-rol" class="btn-primary-fit-modal">Agregar</button>
             </div>
             </form>
         </div>
     </div>
 @endcan
 <!-- //Modal registra rol-->

 <!--Modal actualiza rol-->
 @can('configuraciones.roles.actuliza_rol')
     <div id="actualiza-rol" tabindex="-1" aria-hidden="true" data-modal="actualiza-rol"
         class="modal pointer-events-none opacity-0">
         <div class="backgroud-modal"></div>
         <div class="content-modal-50">
             <div class="modal-content py-4 text-left px-6">
                 <!--Title-->
                 <div class="flex justify-between items-center pb-3 mb-6">
                     <p class="text-2xl font-bold">Editar rol</p>
                     <div class="modal-close cursor-pointer z-50" data-modal="actualiza-rol">
                         <svg class="fill-current text-black" xmlns="http://www.w3.org/2000/svg" width="18"
                             height="18" viewBox="0 0 18 18">
                             <path
                                 d="M14.53 4.53l-1.06-1.06L9 7.94 4.53 3.47 3.47 4.53 7.94 9l-4.47 4.47 1.06 1.06L9 10.06l4.47 4.47 1.06-1.06L10.06 9z">
                             </path>
                         </svg>
                     </div>
                 </div>

                 <!--Body-->
                 <form class="space-y-6" method="POST" id="form_actualizar_rol"
                     action="{{ route('configuraciones.roles.actuliza_rol') }}">
                     @csrf

                     <div>
                         <label for="nombre_rol_edit" class="label-form">Rol</label>
                         <input type="text" name="nombre_rol_edit" id="nombre_rol_edit" class="input-form" required>

                     </div>

                     <h3 class="label-form">Permisos</h3> <label id="permisos_edit[]-error" class="error"
                         for="permisos_edit[]"></label>


                     <div id="div-permisos-edit" class="overflow-y-auto h-[450px] pr-5 permisos-according">
                         <!-- Se genera la lista de permisos mediante ajax-->
                     </div>

                     <input type="text" name="id_rol_edit" id="id_rol_edit" hidden>
             </div>

             <!--Footer-->
             <div class="footer-modal">

                 <a data-modal="actualiza-rol" class="modal-close btn-cancel-fit-modal">Cerrar</a>

                 <button type="submit" id="btn-actualiza-rol" class="btn-primary-fit-modal">Actualizar</button>
             </div>
             </form>
         </div>
     </div>
 @endcan
 <!-- //Modal actualiza rol-->

 <!--Modal confirma eliminacion rol-->
 @can('configuraciones.roles.elimina_rol')
     <div id="confirma-elimina-rol" tabindex="-1" aria-hidden="true" data-modal="confirma-elimina-rol"
         class="modal opacity-0 pointer-events-none fixed w-full h-full top-0 left-0 flex items-center justify-center transition-opacity ">
         <div class="modal-overlay absolute w-full h-full bg-gray-900 opacity-50"></div>

         <div class="modal-container bg-white w-11/12 md:max-w-md mx-auto rounded-lg shadow-lg z-50 overflow-y-auto ">

             <!-- Add margin if you want to see some of the overlay behind the modal-->
             <div class="modal-content py-4 text-left px-6">
                 <!--Body-->
                 <div>
                     <p id="mensaje-notificacion" class=" text-2xl font-bold text-center"></p>
                 </div>
             </div>

             <!--Footer-->

             <form method="POST" id="form_elimina_rol" action="{{ route('configuraciones.roles.elimina_rol') }}">
                 @csrf

                 <div class="footer-modal modal-content">
                     <input type="text" name="id_rol_destroy" id="id_rol_destroy" hidden>
                     <input type="text" name="nombre_rol_destroy" id="nombre_rol_destroy" hidden>

                     <a href="#" data-modal="confirma-elimina-rol"
                         class="modal-close btn-cancel-fit-modal">Cerrar</a>

                     <button type="submit" id="btn-elimina-rol" class="btn-primary-fit-modal">Aceptar</button>
                 </div>
             </form>
         </div>
     </div>
 @endcan
 <!--//Modal confirma eliminacion usuario-->
