<!-- drawer component -->
<div id="drawer-navigation" class="fixed z-40 h-screen p-4 overflow-y-auto bg-gray-800 w-80 hidden" tabindex="-1"
    aria-labelledby="drawer-navigation-label">
    <h5 id="drawer-navigation-label" class="text-base font-semibold text-white uppercase">Menu</h5>
    <button type="button" data-drawer-dismiss="drawer-navigation" aria-controls="drawer-navigation"
        class="text-white bg-transparent hover:bg-red-700 rounded-lg text-sm p-1.5 absolute top-2.5 right-2.5 inline-flex items-center close-menu">
        <svg aria-hidden="true" class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"
            xmlns="http://www.w3.org/2000/svg">
            <path fill-rule="evenodd"
                d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                clip-rule="evenodd"></path>
        </svg>
        <span class="sr-only">Close menu</span>
    </button>
    <div class="py-4 overflow-y-auto">
        <ul class="space-y-2">
            @can('dashboard.inicio')
                <li>
                    <a href="{{ route('dashboard.inicio') }}"
                        class="item-siderbar-menu {{ !Route::is('dashboard.inicio') ?: 'active' }}">
                        <i class="fa-solid fa-house"></i>
                        <span class="ml-3">Inicio</span>
                    </a>
                </li>
            @endcan

            @can('movimientos.entrada.antibiotico', 'movimientos.salida.antibiotico')
                <li>
                    <button type="button"
                        class="item-siderbar-menu w-full accordion_menu {{ !Route::is('registraMovimientos.*') ?: 'active' }} {{ !Route::is('ajusteMovimientos.*') ?: 'active' }}"
                        aria-controls="dropdown-movimientos" data-collapse-toggle="dropdown-movimientos"
                        data-expanded="close">
                        <i class="fa-solid fa-book"></i>
                        <span class="flex-1 ml-3 text-left whitespace-nowrap">Movimientos</span>
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <ul id="dropdown-movimientos" class="hidden py-2 space-y-2">

                        @can('movimientos.entrada.antibiotico', 'movimientos.salida.antibiotico')
                            <li><a href="{{ route('registraMovimientos.index') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('registraMovimientos.index') ?: 'active' }}">Registro
                                    de
                                    movimientos</a>
                            </li>
                        @endcan

                        @can('movimientos.ajusteMovimientos')
                            <li><a href="{{ route('ajusteMovimientos.index') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('ajusteMovimientos.index') ?: 'active' }}">Ajuste
                                    de movimientos</a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcan

            @can('reportes.movimientos')
                <li>
                    <button type="button"
                        class="item-siderbar-menu w-full accordion_menu {{ !Route::is('reporteMovimientos.*') ?: 'active' }}"
                        aria-controls="dropdown-reportes" data-collapse-toggle="dropdown-reportes" data-expanded="close">
                        <i class="fa-regular fa-file"></i>
                        <span class="flex-1 ml-3 text-left whitespace-nowrap">Reportes</span>
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <ul id="dropdown-reportes" class="hidden py-2 space-y-2">

                        @can('reportes.movimientos')
                            <li><a href="{{ route('reporteMovimientos.index') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('reporteMovimientos.index') ?: 'active' }}">Reporte
                                    de
                                    movimientos</a>
                            </li>
                        @endcan
                    </ul>
                </li>
            @endcan


            <!-- Configuraciones -->
            @can('configuraciones.usuarios', 'configuraciones.roles', 'configuraciones.permisos',
                'configuraciones.sucursales', 'configuraciones.terminales')
                <li>
                    <button type="button"
                        class="item-siderbar-menu w-full accordion_menu {{ !Route::is('configuraciones.*') ?: 'active' }}"
                        aria-controls="dropdown-configuraciones" data-collapse-toggle="dropdown-configuraciones"
                        data-expanded="close">
                        <i class="fa-solid fa-gear"></i>
                        <span class="flex-1 ml-3 text-left whitespace-nowrap">Configuraciones</span>
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <ul id="dropdown-configuraciones" class="hidden py-2 space-y-2">

                        @can('configuraciones.usuarios')
                            <li><a href="{{ route('configuraciones.usuarios') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('configuraciones.usuarios') ?: 'active' }}">Usuarios</a>
                            </li>
                        @endcan

                        @can('configuraciones.roles')
                            <li><a href="{{ route('configuraciones.roles') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('configuraciones.roles') ?: 'active' }}">Roles</a>
                            </li>
                        @endcan

                        @can('configuraciones.permisos')
                            <li><a href="{{ route('configuraciones.permisos') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('configuraciones.permisos') ?: 'active' }}">Permisos</a>
                            </li>
                        @endcan

                        @can('configuraciones.sucursales')
                            <li><a href="{{ route('configuraciones.sucursales') }}"
                                    class="subitem-siderbar-menu {{ !Route::is('configuraciones.sucursales') ?: 'active' }}">Sucursales</a>
                            </li>
                        @endcan

                    </ul>
                </li>
            @endcan
            <!-- //Configuraciones -->



            <!-- Monitoreo -->
            @can('monitoreo.monitor')
                <li>
                    <a href="{{ URL::to('/') }}/monitor"
                        class="item-siderbar-menu {{ !Route::is('monitor') ?: 'active' }}">
                        <i class="fa-sharp fa-solid fa-code"></i>
                        <span class="ml-3">Monitoreo</span>
                    </a>
                </li>
            @endcan
            <!-- //Monitoreo -->

            <li class="block lg:hidden">
                <div :class="{ 'block': open, 'hidden': !open }" class="">
                    <div class="container  mx-auto">
                        <div x-data="{ open: false }" class="py-4 border-t border-gray-700">
                            <button @click="open = true" class="flex items-center w-full focus:outline-none">
                                <div class="flex items-center w-full text-left">
                                    <div class="flex-shrink-0">
                                        <i class="fa-regular fa-circle-user text-3xl text-white"></i>
                                    </div>
                                    <div class="ml-3">
                                        <div class="text-base font-medium leading-none text-white">
                                            {{ Auth::user()->nombre }}
                                            {{ Auth::user()->ap_paterno }} {{ Auth::user()->ap_materno }}</div>
                                        <div class="mt-1 text-sm font-medium leading-none text-gray-400">
                                            {{ Auth::user()->privilegio }}</div>
                                    </div>
                                </div>
                                <div class="text-white"><svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg"
                                        :class="{ 'rotate-180': open, 'rotate-0': !open }">

                                        <path fill-rule="evenodd"
                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                            </button>
                            <div x-show="open" @click.away="open = false" class="subitem-siderbar-menu"
                                role="menu" aria-orientation="vertical" aria-labelledby="user-menu"
                                role="menuitem">


                                <a href="{{ route('logout') }}"
                                    onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                                    class="flex flex-row items-center px-3 py-2 mt-1 text-base font-medium text-red-500 rounded-md hover:text-red-700 hover:bg-red-200 focus:outline-none focus:text-red-700 focus:bg-red-200"
                                    role="menuitem">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" viewBox="0 0 24 24"
                                        fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" class="feather feather-log-out">
                                        <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>
                                        <polyline points="16 17 21 12 16 7"></polyline>
                                        <line x1="21" y1="12" x2="9" y2="12"></line>
                                    </svg>
                                    <span class="ml-2">Cerrar sesion</span>
                                </a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST"
                                    class="hidden">
                                    {{ csrf_field() }}
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </li>


        </ul>
    </div>
</div>

<div id="background-menu" class="fixed p-4 overflow-y-auto close-menu2"></div>
