<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\LoginController;

use App\Http\Controllers\Api\ClientesEstacionesController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('login', [LoginController::class, 'login']);
Route::post('logout', [LoginController::class, 'logout'])->middleware('auth:sanctum');

Route::post('validaDatosCliente', [ClientesEstacionesController::class, 'validaKeyCliente'])->middleware('auth:sanctum');
Route::post('validaMACCliente', [ClientesEstacionesController::class, 'validaMACCliente'])->middleware('auth:sanctum');
Route::post('validaKeyCliente', [ClientesEstacionesController::class, 'validaKeyCliente'])->middleware('auth:sanctum');
Route::post('getDatosSucursal', [ClientesEstacionesController::class, 'getDatosSucursal'])->middleware('auth:sanctum');
Route::post('validaSucursalUsuarioCliente', [ClientesEstacionesController::class, 'validaSucursalUsuarioCliente'])->middleware('auth:sanctum');


Route::post('setLoginCliente', [ClientesEstacionesController::class, 'setLoginCliente'])->middleware('auth:sanctum');
Route::post('deleteLoginCliente', [ClientesEstacionesController::class, 'deleteLoginCliente'])->middleware('auth:sanctum');
