<?php

use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/', function () {
    return redirect()->route('login');
});


Route::get('loginCliente/{id}/{token}', 'App\Http\Controllers\Auth\LoginController@loginForCliente');

//Grupo de ruta para el dashboard
Route::namespace('Dashboard')->prefix('dashboard')->group(function () {

    Route::get('inicio', 'DashboardController@show')->name('dashboard.inicio');




    Route::namespace('Movimientos')->prefix('movimientos')->group(function () {

        Route::prefix('registraMovimientos')->group(function () {

            Route::get('/', 'RegistraMovimientosController@show')
                ->name('registraMovimientos.index')
                ->middleware('can:movimientos.entrada.antibiotico')
                ->middleware('can:movimientos.salida.antibiotico');

            Route::post('/getDatosProducto', 'RegistraMovimientosController@getDatosProducto')
                ->name('registraMovimientos.getDatosProducto')
                ->middleware('can:movimientos.entrada.antibiotico')
                ->middleware('can:movimientos.salida.antibiotico');

            Route::post('/registraEntrada', 'RegistraMovimientosController@registraEntrada')
                ->name('registraMovimientos.registraEntrada')
                ->middleware('can:movimientos.entrada.antibiotico');

            Route::post('/registraSalida', 'RegistraMovimientosController@registraSalida')
                ->name('registraMovimientos.registraSalida')
                ->middleware('can:movimientos.salida.antibiotico');
        });



        Route::prefix('ajusteMovimientos')->group(function () {

            Route::get('/', 'AjusteMovimientosController@show')
                ->name('ajusteMovimientos.index')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::get('/getDataMovimientos/{sucursal}/{fechaInicial}/{fechaFinal}', 'AjusteMovimientosController@dataMovimientos')
                ->name('ajusteMovimientos.getData')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::get('/getDataMovimiento/{id}/{sucursal}', 'AjusteMovimientosController@getDataMovimiento')
                ->name('ajusteMovimientos.getDataMovimiento')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::post('/actulizaEntrada', 'AjusteMovimientosController@updateEntrada')
                ->name('ajusteMovimientos.actulizaEntrada')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::post('/actulizaSalida', 'AjusteMovimientosController@updateSalida')
                ->name('ajusteMovimientos.actulizaSalida')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::post('/eliminaRegistro', 'AjusteMovimientosController@deleteRegistro')
                ->name('ajusteMovimientos.eliminaRegistro')
                ->middleware('can:movimientos.ajusteMovimientos');

            Route::post('/corrigeNumReceta', 'AjusteMovimientosController@corrigeNumeroReceta')
                ->name('ajusteMovimientos.corrigeNumReceta')
                ->middleware('can:movimientos.ajusteMovimientos');
        });
    });

    Route::namespace('Reportes')->prefix('reportes')->group(function () {

        Route::prefix('reporteMovimientos')->group(function () {
            Route::get('/', 'ReporteMovimientosController@show')
                ->name('reporteMovimientos.index')
                ->middleware('can:reportes.movimientos');

            Route::get('/getDatosMovimientos/{filtroBusqueda}/{sucursal}/{fechaInicial}/{fechaFinal}/{tipoMovimiento}', 'ReporteMovimientosController@getdataMovimientos')
                ->name('reporteMovimientos.getDataMovimientos')
                ->middleware('can:reportes.movimientos');

            Route::get('/getReporteExcel/{filtroBusqueda}/{sucursal}/{fechaInicial}/{fechaFinal}', 'ReporteMovimientosController@getReporteExcel')
                ->name('reporteMovimientos.getReporteExcel')
                ->middleware('can:reportes.movimientos');

            Route::get('/getReportePDF/{filtroBusqueda}/{sucursal}/{fechaInicial}/{fechaFinal}', 'ReporteMovimientosController@getReportePDF')
                ->name('reporteMovimientos.getReportePDF')
                ->middleware('can:reportes.movimientos');
        });
    });






















    Route::get('/empresa/sucursales/{id}', 'DashboardController@obtenerSucursales')
        ->name("dashboard.sucursales")
        ->middleware('can:dashboard.inicio');













    //Grupo de ruta para el modulo de configuraciones
    Route::namespace('Configuraciones')->prefix("configuraciones")->group(function () {

        Route::prefix('usuarios')->group(function () {
            Route::get('/', 'UsuariosController@show')
                ->name("configuraciones.usuarios")
                ->middleware('can:configuraciones.usuarios');

            Route::get('/usuarios_data', 'UsuariosController@usuariosData')
                ->name("configuraciones.usuarios.usuarios_data")
                ->middleware('can:configuraciones.usuarios');

            Route::get('/usuario_data/{id}', 'UsuariosController@usuarioData')
                ->name('configuraciones.usuarios.usuario_data')
                ->middleware('can:configuraciones.usuarios.actuliza_usuario')
                ->middleware('can:configuraciones.usuarios.elimina_usuario');

            Route::post('/registra_usuario', 'UsuariosController@registraUsuario')
                ->name('configuraciones.usuarios.registra_usuario')
                ->middleware('can:configuraciones.usuarios.registra_usuario');

            Route::post('/actuliza_usuario', 'UsuariosController@actulizaUsuario')
                ->name('configuraciones.usuarios.actuliza_usuario')
                ->middleware('can:configuraciones.usuarios.actuliza_usuario');

            Route::post('/elimina_usuario', 'UsuariosController@eliminaUsuario')
                ->name('configuraciones.usuarios.elimina_usuario')
                ->middleware('can:configuraciones.usuarios.elimina_usuario');
        });

        Route::prefix('roles')->group(function () {
            Route::get('/', 'RolesController@show')
                ->name("configuraciones.roles")
                ->middleware('can:configuraciones.roles');

            Route::get('/roles_data', 'RolesController@rolesData')
                ->name("configuraciones.roles.roles_data")
                ->middleware('can:configuraciones.roles');

            Route::get('/permission_data', 'RolesController@permissionData')
                ->name("configuraciones.roles.permission_data")
                ->middleware('can:configuraciones.roles.registra_rol, configuraciones.roles.actuliza_rol');

            Route::get('/rol_data/{id}', 'RolesController@roleData')
                ->name('configuraciones.roles.role_data')
                ->middleware('can:configuraciones.roles.actuliza_rol');

            Route::post('/registra_rol', 'RolesController@registraRol')
                ->name('configuraciones.roles.registra_rol')
                ->middleware('can:configuraciones.roles.registra_rol');

            Route::post('/actuliza_rol', 'RolesController@actulizaRol')
                ->name('configuraciones.roles.actuliza_rol')
                ->middleware('can:configuraciones.roles.actuliza_rol');

            Route::post('/elimina_rol', 'RolesController@eliminaRol')
                ->name('configuraciones.roles.elimina_rol')
                ->middleware('can:configuraciones.roles.elimina_rol');
        });

        Route::prefix('sucursales')->group(function () {
            Route::get('/', 'SucursalesController@show')
                ->name("configuraciones.sucursales")
                ->middleware('can:configuraciones.sucursales');

            Route::get('/sucursales_data', 'SucursalesController@sucursalesData')
                ->name("configuraciones.sucursales.sucursales_data")
                ->middleware('can:configuraciones.sucursales');

            Route::get('/sucursal_data/{id}', 'SucursalesController@sucursalData')
                ->name('configuraciones.sucursales.sucursal_data')
                ->middleware('can:configuraciones.sucursales.actuliza_sucursal')
                ->middleware('can:configuraciones.sucursales.elimina_sucursal');

            Route::post('/registra_sucursal', 'SucursalesController@registraSucursal')
                ->name("configuraciones.sucursales.registra_sucursal")
                ->middleware('can:configuraciones.sucursales.registra_sucursal');

            Route::post('/actuliza_sucursal', 'SucursalesController@actulizaSucursal')
                ->name("configuraciones.sucursales.actuliza_sucursal")
                ->middleware('can:configuraciones.sucursales.actuliza_sucursal');
        });



        Route::namespace('Permisos')->prefix('permisos')->group(function () {
            Route::get('/', 'PermisosController@show')
                ->name("configuraciones.permisos")
                ->middleware('can:configuraciones.permisos');

            Route::get('/permisos_data', 'PermisosController@permisosData')
                ->name("configuraciones.permisos.permisos_data")
                ->middleware('can:configuraciones.permisos');

            Route::get('/sub_categorias_data/{id}', 'PermisosController@getSubCategorias')
                ->name("configuraciones.permisos.subcategorias_data")
                ->middleware('can:configuraciones.permisos');

            Route::get('/permiso_data/{id}', 'PermisosController@permisoData')
                ->name("configuraciones.permisos.permiso_data")
                ->middleware('can:configuraciones.permisos.actuliza_permiso')
                ->middleware('can:configuraciones.permisos.elimina_permiso');

            Route::post('/registra_permiso', 'PermisosController@registraPermiso')
                ->name('configuraciones.permisos.registra_permiso')
                ->middleware('can:configuraciones.permisos.registra_permiso');

            Route::post('/actuliza_permiso', 'PermisosController@actulizaPermiso')
                ->name('configuraciones.permisos.actuliza_permiso')
                ->middleware('can:configuraciones.permisos.actuliza_permiso');

            Route::post('/elimina_permiso', 'PermisosController@eliminaPermiso')
                ->name('configuraciones.permisos.elimina_permiso')
                ->middleware('can:configuraciones.permisos.elimina_permiso');


            Route::prefix('categorias')->group(function () {
                Route::get('/', 'CategoriasController@show')
                    ->name("configuraciones.permisos.categorias")
                    ->middleware('can:configuraciones.permisos.categorias');

                Route::get('/categorias_data', 'CategoriasController@categoriasData')
                    ->name("configuraciones.permisos.categorias.categorias_data")
                    ->middleware('can:configuraciones.permisos.categorias');

                Route::get('/categoria_data/{id}', 'CategoriasController@categoriaData')
                    ->name("configuraciones.permisos.categorias.categoria_data")
                    ->middleware('can:configuraciones.permisos.categorias.actuliza_categoria')
                    ->middleware('can:configuraciones.permisos.categorias.elimina_categoria');

                Route::post('/registra_categoria', 'CategoriasController@registraCategoria')
                    ->name('configuraciones.permisos.categorias.registra_categoria')
                    ->middleware('can:configuraciones.permisos.categorias.registra_categoria');

                Route::post('/actuliza_categoria', 'CategoriasController@actulizaCategoria')
                    ->name('configuraciones.permisos.categorias.actuliza_categoria')
                    ->middleware('can:configuraciones.permisos.categorias.actuliza_categoria');

                Route::post('/elimina_categoria', 'CategoriasController@eliminaCategoria')
                    ->name('configuraciones.permisos.categorias.elimina_categoria')
                    ->middleware('can:configuraciones.permisos.categorias.elimina_categoria');
            });

            Route::prefix('sub_categorias')->group(function () {
                Route::get('/', 'SubCategoriasController@show')
                    ->name("configuraciones.permisos.subcategorias")
                    ->middleware('can:configuraciones.permisos.subcategorias');

                Route::get('/subcategorias_data', 'SubCategoriasController@subcategoriasData')
                    ->name("configuraciones.permisos.subcategorias.subcategorias_data")
                    ->middleware('can:configuraciones.permisos.subcategorias');

                Route::get('/subcategoria_data/{id}', 'SubCategoriasController@subcategoriaData')
                    ->name("configuraciones.permisos.subcategorias.subcategoria_data")
                    ->middleware('can:configuraciones.permisos.subcategorias.actuliza_subcategoria')
                    ->middleware('can:configuraciones.permisos.subcategorias.elimina_subcategoria');

                Route::post('/registra_subcategoria', 'SubCategoriasController@registraSubcategoria')
                    ->name('configuraciones.permisos.subcategorias.registra_subcategoria')
                    ->middleware('can:configuraciones.permisos.subcategorias.registra_subcategoria');

                Route::post('/actuliza_subcategoria', 'SubCategoriasController@actulizaSubcategoria')
                    ->name('configuraciones.permisos.subcategorias.actuliza_subcategoria')
                    ->middleware('can:configuraciones.permisos.subcategorias.actuliza_subcategoria');

                Route::post('/elimina_subcategoria', 'SubCategoriasController@eliminaSubcategoria')
                    ->name('configuraciones.permisos.subcategorias.elimina_subcategoria')
                    ->middleware('can:configuraciones.permisos.subcategorias.elimina_subcategoria');
            });
        });

        Route::namespace('Catalogos')->prefix('catalogos')->group(function () {
        });
    });
});
