/** @type {import('tailwindcss').Config} */
module.exports = {
    important: true,
    content: [
        './resources/**/*.blade.php',
        './resources/**/*.js',
        './app/**/*.php',
        './resources/**/*.html',
        './resources/**/*.php',
    ],
    opacity: {
        "50": "opacity-0.5",
        "80": "opacity-0.8"
    },
    theme: {
        screens: {
            sm: '640px',
            md: '768px',
            lg: '1024px',
            xl: '1280px',
            '2xl': '1536px',

            'phone': {
                'min': '330px',
                'max': '850px'
            },
            'tablet': {
                'min': '851px',
                'max': '1023px'
            }, // => @media (min-width: 640px) { ... }
            'desktop': {
                'min': '1024px',
                'max': '5280px'
            }, // => @media (min-width: 1280px) { ... }*/

        },
        fontFamily: {
            'poppins': ['Poppins', 'sans-serif'],
            'mono': 'font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;',
        },
        gridTemplateColumns: {

            // Complex site-specific column configuration 'detalles_corte_caja': '234px 242px 304px 235px 485px',

            'detalles_corte_caja': '234px',
            //'detalles_corte_caja': '234px 242px',
            'accordings_corte_caja': '410px 300px 475px',
            'header_corte_caja': '10% 30% 60%',
            'btns_corte_caja': '21% 21% 21% 26%',

            'filtro_recepcion_cortes': '30% 35% 32%',
            'filtro_cierre_cortes': '15% 25% 26% 30%',

            'filtro_entrada_antibiotico': '25% 30% 15% 25%',





            'div-genera-key': '8% 95%',

            'div-movimientos-corte': '67% auto',
            'div-movimientos-corte-resp': '70% 30%',

            'auto-cols-max': 'max-content',
            '1': 'repeat(1, minmax(0, 1fr))',
            '2': 'repeat(2, minmax(0, 1fr))',
            '3': 'repeat(3, minmax(0, 1fr))',
            '4': 'repeat(4, minmax(0, 1fr))',
        },
        gridTemplateRows: {
            'rows-detalles_corte_caja': 'minmax(0, 145px)',

            '1': 'minmax(0, 1fr)',
            '2': 'repeat(2, minmax(0, 1fr))',
            '3': 'repeat(3, minmax(0, 1fr))',
        },
        colors: {
            'blue-200': '#BAE6FD',
            'blue-300': '#90CDF4',
            'blue-400': '#60A5FA',
            'blue-500': '#3B82F6',
            'blue-600': '#2563EB',
            'blue-700': '#1D4ED8',
            'blue-800': '#1E40AF',

            'gray-100': '#F3F4F6',
            'gray-200': '#E5E7EB',
            'gray-300': '#D1D5DB',
            'gray-400': '#9CA3AF',
            'gray-500': '#6B7280',
            'gray-900': '#111827',
            'gray-400': '#9CA3AF',
            'gray-700': '#374151',

            'zinc-300': '#D4D4D8',

            'red-700': '#B91C1C',
            'red-800': '#991B1B',

            'green-600': '#16A34A',
            'green-700': '#15803D',

            'yellow-500': '#EAB308',
            'yellow-600': '#CA8A04',

            'black': '#000000',
            'modal': '#000000cf',

            'orange-400': '#fb923c',
            'orange-500': '#f97316',





            'transparent': 'transparent',

            //Elemntos del login
            'header-login': '#38BDF8',
            'border-input': '#0EA5E9',
            'boton-login': '#38BDF8',
            'boton-login-hover': '#0EA5E9',
            'white': '#FFFFFF',

            //Error login
            'text-error': '#B91C1C',
            'background-error': '#FEE2E2',

            //Elementos del dashboard - nav
            'header-dashboard': '#334155',
            'nav-dashboard': '#38BDF8',
            'text-nav-dashboard': '#334155',
            'border-sub-nav-dashboard': '#334155',
            'hover-sub-nav-dashboard': '#BAE6FD',

            //dashboar - body
            'body-dashboard': '#E5E7EB',
            'border-body-dashboard': '#334155',

            //Elementos del dashboard - corte_caja
            'border-card-corte': '#E5E7EB',
            'border-list-card-corte': '#D1D5DB',
            'text-total-card': '#1D4ED8',
            'boton-corte': '#38BDF8',
            'boton-corte-cancelar': '#FFFFFF',
            'text-corte-cancelar': '#1D4ED8',
            'boton-corte-hover': '#0EA5E9',

            'text-resta': '#DC2626',
            'text-suma': '#16A34A',


            //Elementos del dashboard - modal
            'text-modal': '#334155',

            'boton-modal-reg': '#38BDF8',
            'boton-modal-reg-hover': '#0EA5E9',

            'boton-modal-close': '#fff',
            'boton-modal-close-hover': '#D4D4D8',
            'border-btn-modal-close': '#E5E7EB',

            'footer-modal': '#F9FAFB',

            'border-input-modal': '#9CA3AF',

            //Botones usuarios
            'boton-actualizar': '#EAB308',
            'boton-actualizar-hover': ' #D97706',
            'ring-boton-actualizar': '#D97706',

            'boton-eliminar': '#B91C1C',
            'boton-eliminar-hover': '#991B1B',
            'ring-boton-eliminar': '#FCA5A5',

            'boton-descargar': '#16A34A',
            'boton-descargar-hover': '#15803D',
            'ring-boton-descargar': '#15803D',


            //tabs ajuste de movimientos
            'div-border-tabs': '#E5E7EB',

            //erros
            'text-error': '#334155',

            //botones recepcion de cortes
            'boton-buscar': '#38BDF8',
            'boton-recepcion-disabled': '#9CA3AF',
            'input-disabled': '#D1D5DB',

            'boton-limpiar': '#38BDF8',
            'boton-limpiar-hover': '#0EA5E9',

            'select-disabled': '#D1D5DB',

            'gray-300': '#D1D5DB',

        },
        extend: {
            animation: {
                'spin-slow': 'spin 10s linear infinite',
            }
        },
    },
    plugins: [],
}
