<?php

namespace Tests\Feature\Http\Controllers\Auth;

use Tests\TestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Database\Eloquent\Factories\Factory;

class LoginControllerTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic feature test example.
     *
     * @return void
     */

    /** @test */
    public function muestra_vista_formulario_login()
    {
        $response = $this->get('/login');

        $response->assertStatus(200);
        $response->assertViewIs('auth.login');
    }

    /** @test */
    /*public function valida_inicio_sesion_errores()
    {
        $response = $this->post(route('login'), []);

        $response->assertStatus(302);
        $response->assertSessionHasErrors('email');
    }*/

    /** @test */
    public function valida_inicio_sesion_redirecciona_usuarios()
    {
        $user = Factory::factoryForModel(User::class)->create();

        $response = $this->post(route('login'), [
            'email' => 'admin',
            'password' => 'password'
        ]);

        $response->assertRedirect(route('dashboard.inicio'));
        $this->assertAuthenticatedAs($user);
    }
}
